/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.lite.gef;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.CanonicalStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.lite.setup.LibraryConstrainedSetup;
import org.eclipse.gmf.tests.rt.GeneratedCanvasTest;
import org.eclipse.gmf.tests.setup.SessionSetup;

public class NotationRefreshTest
extends GeneratedCanvasTest {
    public NotationRefreshTest(String name) {
        super(name);
    }

    protected SessionSetup createDefaultSetup() {
        return LibraryConstrainedSetup.getInstance();
    }

    public void testNotationRefreshOnDeleteNode() throws Exception {
        EditPart diagramEP = this.getDiagramEditPart();
        Diagram diagram = (Diagram)diagramEP.getModel();
        EObject diagramElement = diagram.getElement();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagramElement);
        Node nodeA = this.getCanvasInstance().getNodeA();
        EObject elementA = nodeA.getElement();
        EditPart editPartA = this.findEditPart((View)nodeA);
        Command command = RemoveCommand.create((EditingDomain)editingDomain, (Object)elementA.eContainer(), (Object)elementA.eContainingFeature(), (Object)elementA);
        NotationRefreshTest.assertTrue((String)"Failed to obtain command to remove an instance of the domain model element", (command != null && command.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(editingDomain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        NotationRefreshTest.assertNull((String)"RemoveCommand not executed properly", (Object)elementA.eContainer());
        NotationRefreshTest.assertNull((String)"Notational refresh failed on domain element removal", (Object)this.findView((View)diagram, elementA));
        NotationRefreshTest.assertNull((String)"EditPart not removed automatically", (Object)this.findEditPart((View)nodeA));
        NotationRefreshTest.assertFalse((boolean)editPartA.isActive());
    }

    public void testNotationRefreshOnCreateNode() throws Exception {
        EClass newChildClass;
        EObject newChild;
        EReference feature;
        EditPart diagramEP = this.getDiagramEditPart();
        Diagram diagram = (Diagram)diagramEP.getModel();
        EObject diagramElement = diagram.getElement();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagramElement);
        Command command = AddCommand.create((EditingDomain)editingDomain, (Object)diagramElement, (Object)(feature = this.getCanvasInstance().getNodeA().getElement().eContainmentFeature()), (Object)(newChild = (newChildClass = this.getCanvasInstance().getNodeA().getElement().eClass()).getEPackage().getEFactoryInstance().create(newChildClass)));
        NotationRefreshTest.assertTrue((String)"Failed to obtain command to create a new instance of the domain model element", (command != null && command.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(editingDomain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        NotationRefreshTest.assertSame((String)"AddCommand not executed properly", (Object)diagramElement, (Object)newChild.eContainer());
        View newChildView = this.findView((View)diagram, newChild);
        NotationRefreshTest.assertNotNull((String)"Notational refresh failed on domain element creation", (Object)newChildView);
        int visualId = this.getType(newChildView);
        NotationRefreshTest.assertEquals((int)this.getSetup().getGenModel().getNodeA().getVisualID(), (int)visualId);
        EditPart newChildEP = this.findEditPart(newChildView);
        NotationRefreshTest.assertNotNull((String)"EditPart not created automatically", (Object)newChildEP);
    }

    public void testNotationRefreshOnCreateDirectChildNode() throws Exception {
        EditPart diagramEP = this.getDiagramEditPart();
        Diagram diagram = (Diagram)diagramEP.getModel();
        EObject diagramElement = diagram.getElement();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagramElement);
        Node nodeB = this.getCanvasInstance().getNodeB();
        EObject elementB = nodeB.getElement();
        EStructuralFeature directNodeFeature = elementB.eClass().getEStructuralFeature("chapters");
        NotationRefreshTest.assertNotNull((String)"Child feature not found", (Object)directNodeFeature);
        EClass chapterClass = (EClass)directNodeFeature.getEType();
        EObject chapter = chapterClass.getEPackage().getEFactoryInstance().create(chapterClass);
        Command command = AddCommand.create((EditingDomain)editingDomain, (Object)elementB, (Object)directNodeFeature, (Object)chapter);
        NotationRefreshTest.assertTrue((String)"Failed to obtain command to create a new instance of the domain model element", (command != null && command.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(editingDomain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        NotationRefreshTest.assertSame((String)"AddCommand not executed properly", (Object)elementB, (Object)chapter.eContainer());
        View newChildView = this.findView((View)nodeB, chapter);
        NotationRefreshTest.assertNotNull((String)"Notational refresh failed on domain element creation", (Object)newChildView);
        EditPart newChildEP = this.findEditPart(newChildView);
        NotationRefreshTest.assertNotNull((String)"EditPart not created automatically", (Object)newChildEP);
    }

    public void testNotationRefreshOnAttributeChangeThatAffectsSelector() throws Exception {
        EditPart diagramEP = this.getDiagramEditPart();
        Diagram diagram = (Diagram)diagramEP.getModel();
        EObject diagramElement = diagram.getElement();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagramElement);
        Node nodeB = this.getCanvasInstance().getNodeB();
        EObject elementB = nodeB.getElement();
        Bounds bounds = (Bounds)nodeB.getLayoutConstraint();
        Rectangle rectangle = new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        NotationRefreshTest.assertEquals((String)"Unexpected visual ID of the element", (int)this.getSetup().getGenModel().getNodeB().getVisualID(), (int)this.getType((View)nodeB));
        EditPart editPartB = this.findEditPart((View)nodeB);
        Edge edge1 = this.getCanvasInstance().getLinkByClass();
        EObject edge1DomainElement = edge1.getElement();
        Edge edge2 = this.getCanvasInstance().getLinkByRef();
        this.checkLinkEnd(edge1, nodeB);
        this.checkLinkEnd(edge2, nodeB);
        EditPart edge1EP = this.findEditPart((View)edge1);
        EditPart edge2EP = this.findEditPart((View)edge2);
        NotationRefreshTest.assertTrue((boolean)edge1EP.isActive());
        NotationRefreshTest.assertTrue((boolean)edge2EP.isActive());
        EClass elementBClass = elementB.eClass();
        EStructuralFeature feature = elementBClass.getEStructuralFeature("pages");
        NotationRefreshTest.assertNotNull((String)"Failed to find the feature that affects selector", (Object)feature);
        Integer newValue = new Integer(400);
        Command command = SetCommand.create((EditingDomain)editingDomain, (Object)elementB, (Object)feature, (Object)newValue);
        NotationRefreshTest.assertTrue((String)"Failed to obtain command to make a change that affects selector", (command != null && command.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(editingDomain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        NotationRefreshTest.assertEquals((String)"SetCommand not executed properly", (Object)newValue, (Object)elementB.eGet(feature));
        Node newNodeB = (Node)this.findView((View)diagram, elementB);
        NotationRefreshTest.assertNotNull((String)"Notational refresh failed to recreate a new node upon a change that affects selector", (Object)newNodeB);
        NotationRefreshTest.assertNotSame((String)"Notational refresh failed to replace a new node upon a change that affects selector", (Object)nodeB, (Object)newNodeB);
        NotationRefreshTest.assertTrue((String)"Notational refresh failed to change visual ID of the element upon a change that affects selector", (this.getSetup().getGenModel().getNodeB().getVisualID() != this.getType((View)newNodeB) ? 1 : 0) != 0);
        EditPart newEditPartB = this.findEditPart((View)newNodeB);
        NotationRefreshTest.assertNotNull((String)"EditPart not recreated automatically", (Object)newEditPartB);
        NotationRefreshTest.assertNotSame((String)"EditPart not replaced automatically", (Object)editPartB, (Object)newEditPartB);
        NotationRefreshTest.assertFalse((boolean)editPartB.isActive());
        NotationRefreshTest.assertTrue((boolean)newEditPartB.isActive());
        Bounds newBounds = (Bounds)newNodeB.getLayoutConstraint();
        Rectangle newRectangle = new Rectangle(newBounds.getX(), newBounds.getY(), newBounds.getWidth(), newBounds.getHeight());
        NotationRefreshTest.assertEquals((String)"Notational refresh failed to position the new node where the old one was", (Object)rectangle, (Object)newRectangle);
        NotationRefreshTest.assertFalse((boolean)edge2EP.isActive());
        Node nodeA = this.getCanvasInstance().getNodeA();
        Edge newEdge2 = this.findEdgeWithoutElement(diagram, (View)newNodeB, (View)nodeA, 0);
        NotationRefreshTest.assertNotNull((String)"Failed to find the new representation of edge-without-class", (Object)newEdge2);
        EditPart newEdge2EP = this.findEditPart((View)newEdge2);
        NotationRefreshTest.assertNotNull((String)"Link EditPart not recreated automatically", (Object)newEdge2EP);
        NotationRefreshTest.assertNotSame((String)"Link EditPart not replaced automatically", (Object)newEdge2EP, (Object)edge2EP);
        NotationRefreshTest.assertTrue((boolean)newEdge2EP.isActive());
        this.checkLinkEnd(newEdge2, newNodeB);
        NotationRefreshTest.assertFalse((boolean)edge1EP.isActive());
        Edge newEdge1 = this.findEdgeWithElement(diagram, edge1DomainElement);
        NotationRefreshTest.assertNotNull((String)"Failed to find the new representation of edge-with-class", (Object)newEdge1);
        EditPart newEdge1EP = this.findEditPart((View)newEdge1);
        NotationRefreshTest.assertNotNull((String)"Link EditPart not recreated automatically", (Object)newEdge1EP);
        NotationRefreshTest.assertNotSame((String)"Link EditPart not replaced automatically", (Object)newEdge1EP, (Object)edge1EP);
        NotationRefreshTest.assertTrue((boolean)newEdge1EP.isActive());
        this.checkLinkEnd(newEdge1, newNodeB);
    }

    public void testNotationRefreshOnSemanticRerouteWithClass() throws Exception {
        EditPart diagramEP = this.getDiagramEditPart();
        Diagram diagram = (Diagram)diagramEP.getModel();
        EObject diagramElement = diagram.getElement();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagramElement);
        Node nodeB = this.getCanvasInstance().getNodeB();
        Node nodeA = this.getCanvasInstance().getNodeA();
        EditPart bookEP = this.findEditPart((View)nodeB);
        EditPart writerEP = this.findEditPart((View)nodeA);
        NotationRefreshTest.assertNotNull((Object)bookEP);
        NotationRefreshTest.assertNotNull((Object)writerEP);
        Edge opinionsEdge = this.getCanvasInstance().getLinkByClass();
        EObject opinion = opinionsEdge.getElement();
        EditPart opinionEP = this.findEditPart((View)opinionsEdge);
        this.checkLinkEnd(opinionsEdge, nodeA);
        this.checkLinkEnd(opinionsEdge, nodeB);
        EClass writerClass = nodeA.getElement().eClass();
        EObject newWriter = writerClass.getEPackage().getEFactoryInstance().create(writerClass);
        Command writerCommand = AddCommand.create((EditingDomain)editingDomain, (Object)diagramElement, (Object)nodeA.getElement().eContainmentFeature(), (Object)newWriter);
        EClass bookClass = nodeB.getElement().eClass();
        EObject newBook = bookClass.getEPackage().getEFactoryInstance().create(bookClass);
        Command bookCommand = AddCommand.create((EditingDomain)editingDomain, (Object)diagramElement, (Object)nodeB.getElement().eContainmentFeature(), (Object)newBook);
        new EMFCommandOperation(editingDomain, writerCommand).execute((IProgressMonitor)new NullProgressMonitor(), null);
        new EMFCommandOperation(editingDomain, bookCommand).execute((IProgressMonitor)new NullProgressMonitor(), null);
        Node nodeA1 = (Node)this.findView((View)diagram, newWriter);
        Node nodeB1 = (Node)this.findView((View)diagram, newBook);
        EStructuralFeature targetByClassFeature = opinion.eClass().getEStructuralFeature("book");
        Command command = SetCommand.create((EditingDomain)editingDomain, (Object)opinion, (Object)targetByClassFeature, (Object)newBook);
        NotationRefreshTest.assertTrue((String)"Failed to create semantic reroute command", (command != null && command.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(editingDomain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        NotationRefreshTest.assertSame((String)"Command not executed", (Object)newBook, (Object)opinion.eGet(targetByClassFeature));
        NotationRefreshTest.assertTrue((boolean)opinionEP.isActive());
        this.checkLinkEnd(opinionsEdge, nodeA);
        this.checkLinkEnd(opinionsEdge, nodeB1);
        EStructuralFeature sourceByClassFeature = opinion.eClass().getEStructuralFeature("writer");
        command = SetCommand.create((EditingDomain)editingDomain, (Object)opinion, (Object)sourceByClassFeature, (Object)newWriter);
        new EMFCommandOperation(editingDomain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        NotationRefreshTest.assertSame((String)"Command not executed", (Object)newWriter, (Object)opinion.eGet(sourceByClassFeature));
        NotationRefreshTest.assertTrue((boolean)opinionEP.isActive());
        this.checkLinkEnd(opinionsEdge, nodeA1);
        this.checkLinkEnd(opinionsEdge, nodeB1);
    }

    public void testNotationRefreshOnSemanticRerouteWithFeature() throws Exception {
        EditPart diagramEP = this.getDiagramEditPart();
        Diagram diagram = (Diagram)diagramEP.getModel();
        EObject diagramElement = diagram.getElement();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagramElement);
        Node nodeB = this.getCanvasInstance().getNodeB();
        Node nodeA = this.getCanvasInstance().getNodeA();
        EditPart bookEP = this.findEditPart((View)nodeB);
        EditPart writerEP = this.findEditPart((View)nodeA);
        NotationRefreshTest.assertNotNull((Object)bookEP);
        NotationRefreshTest.assertNotNull((Object)writerEP);
        Edge author = this.getCanvasInstance().getLinkByRef();
        this.checkLinkEnd(author, nodeA);
        this.checkLinkEnd(author, nodeB);
        EditPart authorEP = this.findEditPart((View)author);
        EClass writerClass = nodeA.getElement().eClass();
        EObject newWriter = writerClass.getEPackage().getEFactoryInstance().create(writerClass);
        Command writerCommand = AddCommand.create((EditingDomain)editingDomain, (Object)diagramElement, (Object)nodeA.getElement().eContainmentFeature(), (Object)newWriter);
        EClass bookClass = nodeB.getElement().eClass();
        EObject newBook = bookClass.getEPackage().getEFactoryInstance().create(bookClass);
        Command bookCommand = AddCommand.create((EditingDomain)editingDomain, (Object)diagramElement, (Object)nodeB.getElement().eContainmentFeature(), (Object)newBook);
        new EMFCommandOperation(editingDomain, writerCommand).execute((IProgressMonitor)new NullProgressMonitor(), null);
        new EMFCommandOperation(editingDomain, bookCommand).execute((IProgressMonitor)new NullProgressMonitor(), null);
        Node nodeA1 = (Node)this.findView((View)diagram, newWriter);
        Node nodeB1 = (Node)this.findView((View)diagram, newBook);
        EStructuralFeature targetFeature = nodeB.getElement().eClass().getEStructuralFeature("author");
        Command command = SetCommand.create((EditingDomain)editingDomain, (Object)nodeB.getElement(), (Object)targetFeature, (Object)newWriter);
        NotationRefreshTest.assertTrue((String)"Failed to create semantic reroute command", (command != null && command.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(editingDomain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        NotationRefreshTest.assertSame((String)"Command not executed", (Object)newWriter, (Object)nodeB.getElement().eGet(targetFeature));
        NotationRefreshTest.assertTrue((boolean)authorEP.isActive());
        this.checkLinkEnd(author, nodeA1);
        this.checkLinkEnd(author, nodeB);
        EStructuralFeature sourceFeature = nodeA.getElement().eClass().getEStructuralFeature("books");
        final Command rerouteSourceCommand = SetCommand.create((EditingDomain)editingDomain, (Object)newWriter, (Object)sourceFeature, (Object)new BasicEList((Collection)Collections.singleton(newBook)));
        new EMFCommandOperation(editingDomain, (Command)new AbstractCommand(){

            public boolean canExecute() {
                return true;
            }

            public void redo() {
            }

            public void execute() {
                NotationRefreshTest.assertTrue((rerouteSourceCommand != null && rerouteSourceCommand.canExecute() ? 1 : 0) != 0);
            }
        }).execute((IProgressMonitor)new NullProgressMonitor(), null);
        new EMFCommandOperation(editingDomain, rerouteSourceCommand).execute((IProgressMonitor)new NullProgressMonitor(), null);
        NotationRefreshTest.assertNull((String)"Command not executed", (Object)nodeB.getElement().eGet(targetFeature));
        NotationRefreshTest.assertSame((String)"Command not executed", (Object)newWriter, (Object)nodeB1.getElement().eGet(targetFeature));
        NotationRefreshTest.assertFalse((boolean)authorEP.isActive());
        Edge newAuthor = this.findEdgeWithoutElement(diagram, (View)nodeB1, (View)nodeA1, 0);
        NotationRefreshTest.assertNotNull((Object)newAuthor);
        EditPart newAuthorEP = this.findEditPart((View)newAuthor);
        NotationRefreshTest.assertNotNull((Object)newAuthorEP);
        NotationRefreshTest.assertTrue((boolean)newAuthorEP.isActive());
    }

    public void testNotationRefreshOnDeleteLink() throws Exception {
        EditPart diagramEP = this.getDiagramEditPart();
        Diagram diagram = (Diagram)diagramEP.getModel();
        EObject diagramElement = diagram.getElement();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagramElement);
        Node nodeB = this.getCanvasInstance().getNodeB();
        Node nodeA = this.getCanvasInstance().getNodeA();
        EditPart bookEP = this.findEditPart((View)nodeB);
        EditPart writerEP = this.findEditPart((View)nodeA);
        NotationRefreshTest.assertNotNull((Object)bookEP);
        NotationRefreshTest.assertNotNull((Object)writerEP);
        Edge author = this.getCanvasInstance().getLinkByRef();
        this.checkLinkEnd(author, nodeA);
        this.checkLinkEnd(author, nodeB);
        EditPart authorEP = this.findEditPart((View)author);
        NotationRefreshTest.assertNotNull((Object)authorEP);
        NotationRefreshTest.assertTrue((boolean)authorEP.isActive());
        EStructuralFeature targetFeature = nodeB.getElement().eClass().getEStructuralFeature("author");
        NotationRefreshTest.assertSame((Object)nodeA.getElement(), (Object)nodeB.getElement().eGet(targetFeature));
        final Command command = SetCommand.create((EditingDomain)editingDomain, (Object)nodeB.getElement(), (Object)targetFeature, (Object)SetCommand.UNSET_VALUE);
        new EMFCommandOperation(editingDomain, (Command)new AbstractCommand(){

            public boolean canExecute() {
                return true;
            }

            public void redo() {
            }

            public void execute() {
                NotationRefreshTest.assertTrue((String)"Failed to create remove semantic link command", (command != null && command.canExecute() ? 1 : 0) != 0);
            }
        }).execute((IProgressMonitor)new NullProgressMonitor(), null);
        new EMFCommandOperation(editingDomain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        NotationRefreshTest.assertNull((String)"Command not executed", (Object)nodeB.getElement().eGet(targetFeature));
        NotationRefreshTest.assertNull((Object)author.eContainer());
        NotationRefreshTest.assertFalse((boolean)authorEP.isActive());
    }

    public void testNotationRefreshOnSemanticRerouteLinkToNowhere() throws Exception {
        EditPart diagramEP = this.getDiagramEditPart();
        Diagram diagram = (Diagram)diagramEP.getModel();
        EObject diagramElement = diagram.getElement();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagramElement);
        Node nodeB = this.getCanvasInstance().getNodeB();
        Node nodeA = this.getCanvasInstance().getNodeA();
        EditPart bookEP = this.findEditPart((View)nodeB);
        EditPart writerEP = this.findEditPart((View)nodeA);
        NotationRefreshTest.assertNotNull((Object)bookEP);
        NotationRefreshTest.assertNotNull((Object)writerEP);
        Edge opinionsEdge = this.getCanvasInstance().getLinkByClass();
        EObject opinion = opinionsEdge.getElement();
        EditPart opinionEP = this.findEditPart((View)opinionsEdge);
        this.checkLinkEnd(opinionsEdge, nodeA);
        this.checkLinkEnd(opinionsEdge, nodeB);
        EStructuralFeature targetByClassFeature = opinion.eClass().getEStructuralFeature("book");
        final Command command = SetCommand.create((EditingDomain)editingDomain, (Object)opinion, (Object)targetByClassFeature, (Object)SetCommand.UNSET_VALUE);
        new EMFCommandOperation(editingDomain, (Command)new AbstractCommand(){

            public void redo() {
            }

            public void execute() {
                NotationRefreshTest.assertTrue((String)"Failed to create semantic reroute command", (command != null && command.canExecute() ? 1 : 0) != 0);
            }
        }).execute((IProgressMonitor)new NullProgressMonitor(), null);
        new EMFCommandOperation(editingDomain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        NotationRefreshTest.assertNull((String)"Command not executed", (Object)opinion.eGet(targetByClassFeature));
        NotationRefreshTest.assertFalse((boolean)opinionEP.isActive());
        NotationRefreshTest.assertNull((Object)opinionsEdge.eContainer());
    }

    public void testNotationRefreshOnCreateLink() throws Exception {
        EditPart diagramEP = this.getDiagramEditPart();
        Diagram diagram = (Diagram)diagramEP.getModel();
        EObject diagramElement = diagram.getElement();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagramElement);
        Node nodeB = this.getCanvasInstance().getNodeB();
        Node nodeA = this.getCanvasInstance().getNodeA();
        EditPart bookEP = this.findEditPart((View)nodeB);
        EditPart writerEP = this.findEditPart((View)nodeA);
        NotationRefreshTest.assertNotNull((Object)bookEP);
        NotationRefreshTest.assertNotNull((Object)writerEP);
        EClass bookClass = nodeB.getElement().eClass();
        EObject newBook = bookClass.getEPackage().getEFactoryInstance().create(bookClass);
        Command bookCommand = AddCommand.create((EditingDomain)editingDomain, (Object)diagramElement, (Object)nodeB.getElement().eContainmentFeature(), (Object)newBook);
        new EMFCommandOperation(editingDomain, bookCommand).execute((IProgressMonitor)new NullProgressMonitor(), null);
        Node nodeB1 = (Node)this.findView((View)diagram, newBook);
        EStructuralFeature targetFeature = nodeB.getElement().eClass().getEStructuralFeature("author");
        Command command = SetCommand.create((EditingDomain)editingDomain, (Object)newBook, (Object)targetFeature, (Object)nodeA.getElement());
        NotationRefreshTest.assertTrue((String)"Failed to create create semantic link command", (command != null && command.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(editingDomain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        NotationRefreshTest.assertSame((String)"Command not executed", (Object)nodeA.getElement(), (Object)newBook.eGet(targetFeature));
        Edge newAuthor = this.findEdgeWithoutElement(diagram, (View)nodeB1, (View)nodeA, 0);
        NotationRefreshTest.assertNotNull((String)"Failed to create edge in response to semantic link creation", (Object)newAuthor);
        this.checkLinkEnd(newAuthor, nodeA);
        this.checkLinkEnd(newAuthor, nodeB1);
        EditPart newAuthorEP = this.findEditPart((View)newAuthor);
        NotationRefreshTest.assertNotNull((Object)newAuthorEP);
        NotationRefreshTest.assertTrue((boolean)newAuthorEP.isActive());
    }

    public void testCanonicalStyle() throws Exception {
        EditPart diagramEP = this.getDiagramEditPart();
        Diagram diagram = (Diagram)diagramEP.getModel();
        EObject diagramElement = diagram.getElement();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagramElement);
        EReference feature = this.getCanvasInstance().getNodeA().getElement().eContainmentFeature();
        EClass newChildClass = this.getCanvasInstance().getNodeA().getElement().eClass();
        EObject newChild = newChildClass.getEPackage().getEFactoryInstance().create(newChildClass);
        CanonicalStyle style = NotationFactory.eINSTANCE.createCanonicalStyle();
        style.setCanonical(false);
        Command uncanonicalizeCommand = AddCommand.create((EditingDomain)editingDomain, (Object)diagram, (Object)NotationPackage.eINSTANCE.getView_Styles(), (Object)style);
        new EMFCommandOperation(editingDomain, uncanonicalizeCommand).execute((IProgressMonitor)new NullProgressMonitor(), null);
        Command command = AddCommand.create((EditingDomain)editingDomain, (Object)diagramElement, (Object)feature, (Object)newChild);
        NotationRefreshTest.assertTrue((String)"Failed to obtain command to create a new instance of the domain model element", (command != null && command.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(editingDomain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        NotationRefreshTest.assertSame((String)"AddCommand not executed properly", (Object)diagramElement, (Object)newChild.eContainer());
        View newChildView = this.findView((View)diagram, newChild);
        NotationRefreshTest.assertNull((String)"Notational child created for a view whose isCanonical() is false", (Object)newChildView);
        Command canonicalizeCommand = SetCommand.create((EditingDomain)editingDomain, (Object)style, (Object)NotationPackage.eINSTANCE.getCanonicalStyle_Canonical(), (Object)Boolean.TRUE);
        new EMFCommandOperation(editingDomain, canonicalizeCommand).execute((IProgressMonitor)new NullProgressMonitor(), null);
        newChildView = this.findView((View)diagram, newChild);
        NotationRefreshTest.assertNotNull((String)"Setting view's isCanonical() to true should create missing notational children", (Object)newChildView);
        int visualId = this.getType(newChildView);
        NotationRefreshTest.assertEquals((int)this.getSetup().getGenModel().getNodeA().getVisualID(), (int)visualId);
        EditPart newChildEP = this.findEditPart(newChildView);
        NotationRefreshTest.assertNotNull((String)"EditPart not created automatically", (Object)newChildEP);
    }

    private void checkLinkEnd(Edge edge, Node node) {
        NotationRefreshTest.assertTrue((node.equals(edge.getSource()) || node.equals(edge.getTarget()) ? 1 : 0) != 0);
    }

    private int getType(View view) {
        return Integer.parseInt(view.getType());
    }

    private View findView(View container, EObject child) {
        for (View next : container.getChildren()) {
            if (!child.equals(next.getElement())) continue;
            return next;
        }
        return null;
    }

    private Edge findEdgeWithElement(Diagram diagram, EObject element) {
        for (Edge next : diagram.getEdges()) {
            if (!next.isSetElement() || next.getElement() != element) continue;
            return next;
        }
        return null;
    }

    private Edge findEdgeWithoutElement(Diagram diagram, View source, View target, int index) {
        int count = 0;
        for (Edge next : diagram.getEdges()) {
            if (!next.isSetElement() || next.getElement() != null || next.getSource() != source || next.getTarget() != target) continue;
            if (count == index) {
                return next;
            }
            ++count;
        }
        return null;
    }
}

