/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.impl;

import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.ResourceGetter;
import org.eclipse.emf.cdo.client.ResourceManager;
import org.eclipse.net4j.util.ImplementationError;

public class ResourceGetterImpl
implements ResourceGetter {
    private ResourceManager resourceManager;
    private int lastRID = 0;
    private CDOResource lastResource = null;

    public ResourceGetterImpl(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public CDOResource getResource(int rid) {
        if (rid != this.lastRID) {
            CDOResource resource = this.resourceManager.getResource(rid);
            if (resource == null) {
                throw new ImplementationError("No resource for rid " + rid);
            }
            if (resource.getRID() != rid) {
                throw new ImplementationError("resource.getRID()= " + resource.getRID() + ", rid=" + rid);
            }
            this.lastResource = resource;
            this.lastRID = rid;
        }
        return this.lastResource;
    }

    public CDOResource getResource(long oid) {
        int rid = this.resourceManager.getPackageManager().getOidEncoder().getRID(oid);
        return this.getResource(rid);
    }
}

