/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.http.internal.common;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.internal.net4j.channel.Channel;
import org.eclipse.net4j.http.internal.common.HTTPConnector;

public class HTTPChannel
extends Channel {
    private long outputOperationCount = 1L;
    private long inputOperationCount;
    private Map<Long, HTTPConnector.ChannelOperation> inputOperationQuarantine = new ConcurrentHashMap<Long, HTTPConnector.ChannelOperation>();
    private CountDownLatch openAck = new CountDownLatch(1);
    private boolean inverseRemoved;

    public long getOutputOperationCount() {
        return this.outputOperationCount;
    }

    public void increaseOutputOperationCount() {
        ++this.outputOperationCount;
    }

    public long getInputOperationCount() {
        return this.inputOperationCount;
    }

    public void increaseInputOperationCount() {
        ++this.inputOperationCount;
    }

    public void quarantineInputOperation(long count, HTTPConnector.ChannelOperation operation) {
        this.inputOperationQuarantine.put(count, operation);
    }

    public HTTPConnector.ChannelOperation getQuarantinedInputOperation(long count) {
        return this.inputOperationQuarantine.remove(count);
    }

    public void openAck() {
        this.openAck.countDown();
    }

    public void waitForOpenAck(long timeout) {
        try {
            this.openAck.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {}
    }

    public boolean isInverseRemoved() {
        return this.inverseRemoved;
    }

    public void setInverseRemoved() {
        this.inverseRemoved = true;
    }

    protected void doDeactivate() throws Exception {
        for (HTTPConnector.ChannelOperation operation : this.inputOperationQuarantine.values()) {
            operation.dispose();
        }
        this.inputOperationQuarantine.clear();
        super.doDeactivate();
    }
}

