/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl;

import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.internal.db.ddl.DBTable;
import org.eclipse.net4j.spi.db.DBSchemaElement;

public class DBField
extends DBSchemaElement
implements IDBField {
    public static final int DEFAULT_DECIMAL_PRECISION = 5;
    public static final int DEFAULT_SCALE = 0;
    public static final int DEFAULT_CHAR_LENGTH = 1;
    public static final int DEFAULT_VARCHAR_LENGTH = 255;
    private DBTable table;
    private String name;
    private DBType type;
    private int precision;
    private int scale;
    private boolean notNull;
    private int position;

    public DBField(DBTable table, String name, DBType type, int precision, int scale, boolean notNull, int position) {
        this.table = table;
        this.name = name;
        this.type = type;
        this.precision = precision;
        this.scale = scale;
        this.notNull = notNull;
        this.position = position;
    }

    public IDBSchema getSchema() {
        return this.table.getSchema();
    }

    public DBTable getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DBType getType() {
        return this.type;
    }

    public void setType(DBType type) {
        this.type = type;
    }

    public int getPrecision() {
        if (this.precision == -1) {
            switch (this.type) {
                case CHAR: {
                    return 1;
                }
                case VARCHAR: 
                case VARBINARY: {
                    return 255;
                }
                case NUMERIC: 
                case DECIMAL: {
                    return 5;
                }
            }
        }
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        if (this.scale == -1) {
            return 0;
        }
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public void setNotNull(boolean on) {
        this.notNull = on;
    }

    public int getPosition() {
        return this.position;
    }

    public String getFullName() {
        return String.valueOf(this.table.getName()) + "." + this.name;
    }

    public String formatPrecision() {
        int precision = this.getPrecision();
        if (precision > 0) {
            return "(" + precision + ")";
        }
        return "";
    }

    public String formatPrecisionAndScale() {
        if (this.scale == -1) {
            return "(" + this.getPrecision() + ")";
        }
        return "(" + this.getPrecision() + ", " + this.scale + ")";
    }

    public void appendValue(StringBuilder builder, Object value) {
        if (value == null) {
            builder.append("NULL");
        } else {
            this.type.appendValue(builder, value);
        }
    }
}

