/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterPackagesAction;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.dialogs.SelectPackageDialog;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterGeneratedPackagesAction
extends RegisterPackagesAction {
    private static final String TITLE = Messages.getString("RegisterGeneratedPackagesAction.0");
    private static final String TOOL_TIP = Messages.getString("RegisterGeneratedPackagesAction.1");
    private EPackage.Registry registry = EPackage.Registry.INSTANCE;

    public RegisterGeneratedPackagesAction(IWorkbenchPage page, CDOSession session) {
        super(page, TITLE, TOOL_TIP, null, session);
    }

    @Override
    protected List<EPackage> getEPackages(IWorkbenchPage page, CDOSession session) {
        Shell shell = page.getWorkbenchWindow().getShell();
        SelectPackageDialog dialog = new SelectPackageDialog(shell, Messages.getString("RegisterGeneratedPackagesAction.2"), Messages.getString("RegisterGeneratedPackagesAction.3"), session.getPackageRegistry().keySet());
        if (dialog.open() == 0) {
            Set<String> checkedURIs = dialog.getCheckedURIs();
            ArrayList<EPackage> ePackages = new ArrayList<EPackage>(checkedURIs.size());
            for (String uri : checkedURIs) {
                try {
                    EPackage ePackage = this.registry.getEPackage(uri);
                    ePackages.add(ePackage);
                }
                catch (RuntimeException ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            return ePackages;
        }
        return null;
    }

    public class EPackageFactoryValidator
    implements IInputValidator {
        public String isValid(String uri) {
            if (uri == null || uri.length() == 0) {
                return "";
            }
            return RegisterGeneratedPackagesAction.this.registry.containsKey((Object)uri) ? null : MessageFormat.format(Messages.getString("RegisterGeneratedPackagesAction.5"), uri);
        }
    }
}

