/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.internal.ui.SharedIcons;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.CDOEditorInput;
import org.eclipse.emf.cdo.view.CDOAudit;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.ui.IPersistableElement;

public class CDOEditorInputImpl
extends PlatformObject
implements CDOEditorInput {
    private CDOView view;
    private boolean viewOwned;
    private String resourcePath;

    public CDOEditorInputImpl(CDOView view, String resourcePath) {
        this(view, resourcePath, false);
    }

    public CDOEditorInputImpl(CDOView view, String resourcePath, boolean viewOwned) {
        this.view = view;
        this.viewOwned = viewOwned;
        this.resourcePath = resourcePath;
    }

    public CDOView getView() {
        return this.view;
    }

    public boolean isViewOwned() {
        return this.viewOwned;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        switch (this.view.getViewType()) {
            case TRANSACTION: {
                return SharedIcons.getDescriptor("obj16/cdo_editor");
            }
            case READONLY: {
                return SharedIcons.getDescriptor("obj16/cdo_editor_readonly");
            }
            case AUDIT: {
                return SharedIcons.getDescriptor("obj16/cdo_editor_historical");
            }
        }
        return null;
    }

    public String getName() {
        if (this.resourcePath != null) {
            return new Path(this.resourcePath).lastSegment();
        }
        return this.view.getSession().repository().getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        if (this.view.isClosed()) {
            return Messages.getString("CDOEditorInputImpl.0");
        }
        CDOSession session = this.view.getSession();
        String repositoryName = session.repository().getName();
        StringBuilder builder = new StringBuilder();
        builder.append(repositoryName);
        if (this.resourcePath != null) {
            builder.append(this.resourcePath);
        }
        builder.append(" [");
        builder.append(session.getSessionID());
        builder.append(":");
        builder.append(this.view.getViewID());
        builder.append("]");
        if (this.view.getViewType() != CDOCommonView.Type.TRANSACTION) {
            builder.append(" readonly");
        }
        if (this.view instanceof CDOAudit) {
            builder.append(MessageFormat.format(" {0,date} {0,time}", ((CDOAudit)this.view).getTimeStamp()));
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CDOEditorInputImpl) {
            CDOEditorInputImpl that = (CDOEditorInputImpl)obj;
            return ObjectUtil.equals((Object)this.view, (Object)that.view) && ObjectUtil.equals((Object)this.resourcePath, (Object)that.resourcePath);
        }
        return false;
    }
}

