/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.asm.lib;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.Messages;
import org.eclipse.m2m.atl.engine.asm.lib.SOTSExpression2;
import org.eclipse.m2m.atl.engine.emfvm.StackFrame;
import org.eclipse.m2m.atl.engine.emfvm.VMException;
import org.eclipse.m2m.atl.engine.emfvm.lib.AbstractStackFrame;
import org.eclipse.m2m.atl.engine.emfvm.lib.ExecEnv;
import org.eclipse.m2m.atl.engine.emfvm.lib.LibExtension;
import org.eclipse.m2m.atl.engine.emfvm.lib.Operation;
import org.eclipse.m2m.atl.engine.emfvm.lib.Tuple;

public class ASMString
implements LibExtension {
    public void apply(ExecEnv execEnv, Map options) {
        execEnv.registerOperation(String.class, ASMString.createEvalSOTS());
        execEnv.registerOperation(String.class, ASMString.createEvalSOTSBrackets());
        execEnv.registerOperation(String.class, new Operation(2, "writeTo"){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                return ASMString.writeToWithCharset(frame, (String)localVars[0], (String)localVars[1], null);
            }
        });
        execEnv.registerOperation(String.class, new Operation(3, "writeToWithCharset"){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                return ASMString.writeToWithCharset(frame, (String)localVars[0], (String)localVars[1], (String)localVars[2]);
            }
        });
    }

    public static Operation createEvalSOTS() {
        return new Operation(2, "evalSOTS"){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                String self = (String)localVars[0];
                Tuple args = (Tuple)localVars[1];
                Object ret = null;
                try {
                    ret = new SOTSExpression2(self).exec((StackFrame)frame, args);
                }
                catch (Exception e) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                }
                return ret;
            }
        };
    }

    public static Operation createEvalSOTSBrackets() {
        return new Operation(2, "evalSOTSBrackets"){

            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.getLocalVars();
                String self = (String)localVars[0];
                Tuple args = (Tuple)localVars[1];
                StringBuffer ret = new StringBuffer();
                StringReader in = new StringReader(self);
                try {
                    boolean done = false;
                    do {
                        int c = ((Reader)in).read();
                        switch (c) {
                            case -1: {
                                done = true;
                                break;
                            }
                            case 123: {
                                StringBuffer exp = new StringBuffer();
                                while ((c = ((Reader)in).read()) != 125) {
                                    exp.append((char)c);
                                }
                                Object result = new SOTSExpression2(exp.toString()).exec((StackFrame)frame, args);
                                if (result instanceof Collection) {
                                    result = ((Collection)result).iterator().next();
                                }
                                ret.append(result.toString());
                                break;
                            }
                            default: {
                                ret.append((char)c);
                            }
                        }
                    } while (!done);
                }
                catch (Exception e) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                }
                return ret.toString();
            }
        };
    }

    private static boolean writeToWithCharset(AbstractStackFrame frame, String self, String fileName, String charset) throws VMException {
        boolean ret = false;
        try {
            File file = ASMString.getFile(fileName);
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            PrintStream out = null;
            out = charset == null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(file)), true) : new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), true, charset);
            out.print(self);
            out.close();
            ret = true;
        }
        catch (IOException ioe) {
            throw new VMException(frame, ioe.getLocalizedMessage(), (Throwable)ioe);
        }
        return ret;
    }

    private static File getFile(String path) {
        String newPath = path;
        if (Platform.isRunning()) {
            IPath location = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path)).getLocation();
            if (location != null) {
                newPath = location.toString();
            } else {
                ATLLogger.info((String)Messages.getString("ASMString_WORKSPACE_FILE_NOT_FOUND", new Object[]{path}));
            }
        } else {
            ATLLogger.info((String)Messages.getString("ASMString_WORKSPACE_NOT_FOUND"));
        }
        return new File(newPath);
    }
}

