/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.graphql.tck.dynamic.schema;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.graphql.tck.dynamic.DynamicPaths;
import org.eclipse.microprofile.graphql.tck.dynamic.schema.TestData;
import org.testng.annotations.DataProvider;

public class SchemaTestDataProvider {
    private static final Logger LOG = Logger.getLogger(SchemaTestDataProvider.class.getName());
    private static final String PIPE = "|";
    private static final String DELIMITER = "\\|";
    private static final String COMMENT = "#";
    private static final String FILE_TYPE = ".csv";
    private static final String OR = "'OR'";

    private SchemaTestDataProvider() {
    }

    @DataProvider(name="schemaSnippets")
    public static Object[][] getSnippetTestData() {
        List<Path> dataFiles = SchemaTestDataProvider.getDataFiles();
        List<TestData> testDataList = SchemaTestDataProvider.toListOfTestData(dataFiles);
        Object[][] testParameters = new Object[testDataList.size()][1];
        for (int row = 0; row < testDataList.size(); ++row) {
            TestData testData = testDataList.get(row);
            testParameters[row][0] = testData;
        }
        return testParameters;
    }

    private static List<Path> getDataFiles() {
        ArrayList<Path> f = new ArrayList<Path>();
        try {
            f.addAll(SchemaTestDataProvider.toListOfPaths(DynamicPaths.getDataForImplementation()));
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "No implementation specific tests found [{0}]", ex.getMessage());
        }
        if (!SchemaTestDataProvider.disableSpecificationTests()) {
            try {
                f.addAll(SchemaTestDataProvider.toListOfPaths(DynamicPaths.getDataForSpecification()));
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "No specification tests found [{0}]", ex.getMessage());
            }
        }
        return f;
    }

    private static List<Path> toListOfPaths(DirectoryStream<Path> directoryStream) {
        ArrayList<Path> files = new ArrayList<Path>();
        for (Path p : directoryStream) {
            if (Files.isDirectory(p, new LinkOption[0]) || !p.getFileName().toString().endsWith(FILE_TYPE)) continue;
            files.add(p);
        }
        return files;
    }

    private static List<TestData> toListOfTestData(List<Path> testFolders) {
        LinkedList<TestData> testDataList = new LinkedList<TestData>();
        for (Path testFile : testFolders) {
            try {
                testDataList.addAll(SchemaTestDataProvider.toTestData(testFile));
            }
            catch (IOException ioe) {
                LOG.log(Level.SEVERE, "Could not add test case {0} - {1}", new Object[]{testFile.getFileName().toString(), ioe.getMessage()});
            }
        }
        return testDataList;
    }

    private static List<TestData> toTestData(Path testFile) throws IOException {
        LinkedList<TestData> testDataList = new LinkedList<TestData>();
        List<String> content = Files.readAllLines(testFile);
        String currentHeader = "";
        for (String line : content) {
            if (SchemaTestDataProvider.validLine(line)) {
                String[] parts = line.split(DELIMITER);
                if (parts.length == 4) {
                    TestData testData = SchemaTestDataProvider.createTestData(currentHeader, testFile.getFileName().toString(), parts);
                    testDataList.add(testData);
                    continue;
                }
                LOG.log(Level.SEVERE, "Could not add test case {0} - {1}", new Object[]{testFile.getFileName().toString(), "Does not contain 3 parts [" + parts.length + "]"});
                continue;
            }
            if (!SchemaTestDataProvider.isHeader(line)) continue;
            currentHeader = line.substring(line.indexOf(COMMENT) + 1).trim();
        }
        return testDataList;
    }

    private static TestData createTestData(String header, String filename, String[] parts) {
        TestData testData = new TestData();
        testData.setCount(Integer.valueOf(parts[0]));
        testData.setHeader(header);
        testData.setName(filename);
        String count = parts[0].trim();
        String snippet = parts[1].trim();
        if (snippet == null || snippet.isEmpty()) {
            snippet = null;
        }
        testData.setSnippetSearchTerm(snippet);
        String containsString = parts[2].trim();
        if (containsString.contains(OR)) {
            String[] containsStrings;
            for (String oneOf : containsStrings = containsString.split(OR)) {
                testData.addContainsString(oneOf.trim());
            }
        } else {
            testData.addContainsString(containsString);
        }
        testData.setErrorMessage("(" + count + ") - " + parts[3].trim());
        return testData;
    }

    private static boolean validLine(String line) {
        return !line.isEmpty() && line.trim().contains(PIPE) && !SchemaTestDataProvider.isHeader(line);
    }

    private static boolean isHeader(String line) {
        return line.trim().startsWith(COMMENT);
    }

    private static boolean disableSpecificationTests() {
        return Boolean.valueOf(System.getProperty("disableSpecificationTests", "false"));
    }
}

