/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ImmutableRemovedImage;

@Value.Immutable
public interface RemovedImage {
    public Type type();

    @Nullable
    public String imageId();

    @JsonCreator
    public static RemovedImage create(@JsonProperty(value="Untagged") String untagged, @JsonProperty(value="Deleted") String deleted) {
        if (untagged != null) {
            return ImmutableRemovedImage.builder().type(Type.UNTAGGED).imageId(untagged).build();
        }
        if (deleted != null) {
            return ImmutableRemovedImage.builder().type(Type.DELETED).imageId(deleted).build();
        }
        return ImmutableRemovedImage.builder().type(Type.UNKNOWN).build();
    }

    public static RemovedImage create(Type type, String imageId) {
        return ImmutableRemovedImage.builder().type(type).imageId(imageId).build();
    }

    public static enum Type {
        UNTAGGED,
        DELETED,
        UNKNOWN;

    }
}

