package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link ReplicatedService}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableReplicatedService.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableReplicatedService
    implements ReplicatedService {
  private final @Nullable Long replicas;
  private final @Nullable Long maxConcurrent;

  private ImmutableReplicatedService(
      @Nullable Long replicas,
      @Nullable Long maxConcurrent) {
    this.replicas = replicas;
    this.maxConcurrent = maxConcurrent;
  }

  /**
   * @return The value of the {@code replicas} attribute
   */
  @JsonProperty("Replicas")
  @Override
  public @Nullable Long replicas() {
    return replicas;
  }

  /**
   * @return The value of the {@code maxConcurrent} attribute
   */
  @JsonProperty("MaxConcurrent")
  @Override
  public @Nullable Long maxConcurrent() {
    return maxConcurrent;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReplicatedService#replicas() replicas} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for replicas (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableReplicatedService withReplicas(@Nullable Long value) {
    if (Objects.equals(this.replicas, value)) return this;
    return new ImmutableReplicatedService(value, this.maxConcurrent);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReplicatedService#maxConcurrent() maxConcurrent} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxConcurrent (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableReplicatedService withMaxConcurrent(@Nullable Long value) {
    if (Objects.equals(this.maxConcurrent, value)) return this;
    return new ImmutableReplicatedService(this.replicas, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReplicatedService} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReplicatedService
        && equalsByValue((ImmutableReplicatedService) another);
  }

  private boolean equalsByValue(ImmutableReplicatedService another) {
    return Objects.equals(replicas, another.replicas)
        && Objects.equals(maxConcurrent, another.maxConcurrent);
  }

  /**
   * Computes a hash code from attributes: {@code replicas}, {@code maxConcurrent}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(replicas);
    h += (h << 5) + Objects.hashCode(maxConcurrent);
    return h;
  }

  /**
   * Prints the immutable value {@code ReplicatedService} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReplicatedService{"
        + "replicas=" + replicas
        + ", maxConcurrent=" + maxConcurrent
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ReplicatedService} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ReplicatedService instance
   */
  public static ImmutableReplicatedService copyOf(ReplicatedService instance) {
    if (instance instanceof ImmutableReplicatedService) {
      return (ImmutableReplicatedService) instance;
    }
    return ImmutableReplicatedService.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableReplicatedService ImmutableReplicatedService}.
   * <pre>
   * ImmutableReplicatedService.builder()
   *    .replicas(Long | null) // nullable {@link ReplicatedService#replicas() replicas}
   *    .maxConcurrent(Long | null) // nullable {@link ReplicatedService#maxConcurrent() maxConcurrent}
   *    .build();
   * </pre>
   * @return A new ImmutableReplicatedService builder
   */
  public static ImmutableReplicatedService.Builder builder() {
    return new ImmutableReplicatedService.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableReplicatedService ImmutableReplicatedService}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements ReplicatedService.Builder {
    private Long replicas;
    private Long maxConcurrent;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ReplicatedService} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ReplicatedService instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Long replicasValue = instance.replicas();
      if (replicasValue != null) {
        replicas(replicasValue);
      }
      @Nullable Long maxConcurrentValue = instance.maxConcurrent();
      if (maxConcurrentValue != null) {
        maxConcurrent(maxConcurrentValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ReplicatedService#replicas() replicas} attribute.
     * @param replicas The value for replicas (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Replicas")
    public final Builder replicas(@Nullable Long replicas) {
      this.replicas = replicas;
      return this;
    }

    /**
     * Initializes the value for the {@link ReplicatedService#maxConcurrent() maxConcurrent} attribute.
     * @param maxConcurrent The value for maxConcurrent (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("MaxConcurrent")
    public final Builder maxConcurrent(@Nullable Long maxConcurrent) {
      this.maxConcurrent = maxConcurrent;
      return this;
    }

    /**
     * Builds a new {@link ImmutableReplicatedService ImmutableReplicatedService}.
     * @return An immutable instance of ReplicatedService
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableReplicatedService build() {
      return new ImmutableReplicatedService(replicas, maxConcurrent);
    }
  }
}
