/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.command;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.command.internal.CommandEventParameter;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

@Deprecated
public class CommandExecutor {
    private static final String LSP_COMMAND_CATEGORY_ID = "org.eclipse.lsp4e.commandCategory";
    private static final String LSP_COMMAND_PARAMETER_TYPE_ID = "org.eclipse.lsp4e.commandParameterType";
    private static final String LSP_PATH_PARAMETER_TYPE_ID = "org.eclipse.lsp4e.pathParameterType";

    public static @Nullable CompletableFuture<Object> executeCommandClientSide(Command command, IDocument document) {
        CompletableFuture<Object> r;
        IPath path = LSPEclipseUtils.toPath(document);
        if (path == null) {
            path = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        }
        if ((r = CommandExecutor.executeCommandClientSide(command, path)) != null) {
            return r;
        }
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri != null) {
            return CommandExecutor.executeFallbackClientSide(command, uri);
        }
        return CompletableFuture.completedFuture(null);
    }

    public static @Nullable CompletableFuture<Object> executeCommandClientSide(Command command, IResource resource) {
        CompletableFuture<Object> r = CommandExecutor.executeCommandClientSide(command, resource.getFullPath());
        if (r != null) {
            return r;
        }
        URI uri = LSPEclipseUtils.toUri(resource);
        if (uri != null) {
            return CommandExecutor.executeFallbackClientSide(command, uri);
        }
        return CompletableFuture.completedFuture(null);
    }

    private static @Nullable CompletableFuture<Object> executeCommandClientSide(Command command, @Nullable IPath path) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        ParameterizedCommand parameterizedCommand = CommandExecutor.createEclipseCoreCommand(command, path, workbench);
        if (parameterizedCommand == null) {
            return null;
        }
        IHandlerService handlerService = (IHandlerService)workbench.getService(IHandlerService.class);
        if (handlerService == null) {
            return null;
        }
        try {
            return CompletableFuture.completedFuture(handlerService.executeCommand(parameterizedCommand, null));
        }
        catch (ExecutionException | NotDefinedException e) {
            LanguageServerPlugin.logError(e);
        }
        catch (NotEnabledException | NotHandledException throwable) {
            // empty catch block
        }
        return null;
    }

    private static @Nullable CompletableFuture<Object> executeFallbackClientSide(Command command, URI initialUri) {
        if (command.getArguments() != null) {
            WorkspaceEdit edit = CommandExecutor.createWorkspaceEdit(command.getArguments(), initialUri);
            LSPEclipseUtils.applyWorkspaceEdit(edit, command.getTitle());
            return CompletableFuture.completedFuture(null);
        }
        return null;
    }

    private static @Nullable ParameterizedCommand createEclipseCoreCommand(Command command, @Nullable IPath context, IWorkbench workbench) {
        String commandId = command.getCommand();
        ICommandService commandService = (ICommandService)workbench.getService(ICommandService.class);
        if (commandService == null) {
            return null;
        }
        org.eclipse.core.commands.Command coreCommand = commandService.getCommand(commandId);
        if (!coreCommand.isDefined()) {
            ParameterType commandParamType = commandService.getParameterType(LSP_COMMAND_PARAMETER_TYPE_ID);
            ParameterType pathParamType = commandService.getParameterType(LSP_PATH_PARAMETER_TYPE_ID);
            Category category = commandService.getCategory(LSP_COMMAND_CATEGORY_ID);
            IParameter[] parameters = new IParameter[]{new CommandEventParameter(commandParamType, command.getTitle(), "org.eclipse.lsp4e.command.param"), new CommandEventParameter(pathParamType, command.getTitle(), "org.eclipse.lsp4e.path.param")};
            coreCommand.define(commandId, null, category, parameters);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("org.eclipse.lsp4e.command.param", command);
        parameters.put("org.eclipse.lsp4e.path.param", context);
        ParameterizedCommand parameterizedCommand = ParameterizedCommand.generateCommand((org.eclipse.core.commands.Command)coreCommand, parameters);
        return parameterizedCommand;
    }

    private static WorkspaceEdit createWorkspaceEdit(List<Object> commandArguments, URI initialUri) {
        WorkspaceEdit workspaceEdit = new WorkspaceEdit();
        HashMap<String, List> changes = new HashMap<String, List>();
        workspaceEdit.setChanges(changes);
        Pair currentEntry = new Pair(initialUri, new ArrayList());
        commandArguments.stream().flatMap(item -> {
            if (item instanceof List) {
                List list = (List)item;
                return list.stream();
            }
            return List.of(item).stream();
        }).forEach(arg -> {
            JsonObject jsonObject;
            Gson gson;
            WorkspaceEdit wEdit;
            if (arg instanceof String) {
                URI uri;
                String argString = (String)arg;
                changes.put(((URI)pair.key).toString(), (List)pair.value);
                IResource res = LSPEclipseUtils.findResourceFor(argString);
                if (res != null && (uri = res.getLocationURI()) != null) {
                    pair.key = uri;
                    pair.value = new ArrayList();
                }
            } else if (arg instanceof WorkspaceEdit) {
                WorkspaceEdit wsEdit = (WorkspaceEdit)arg;
                changes.putAll(wsEdit.getChanges());
            } else if (arg instanceof TextEdit) {
                TextEdit textEdit = (TextEdit)arg;
                ((List)pair.value).add(textEdit);
            } else if (arg instanceof Map) {
                Gson gson2 = new Gson();
                TextEdit edit = (TextEdit)gson2.fromJson(gson2.toJson(arg), TextEdit.class);
                if (edit != null) {
                    ((List)pair.value).add(edit);
                }
            } else if (arg instanceof JsonPrimitive) {
                JsonPrimitive json = (JsonPrimitive)arg;
                if (json.isString()) {
                    URI uri;
                    changes.put(((URI)pair.key).toString(), (List)pair.value);
                    IResource res = LSPEclipseUtils.findResourceFor(json.getAsString());
                    if (res != null && (uri = res.getLocationURI()) != null) {
                        pair.key = uri;
                        pair.value = new ArrayList();
                    }
                }
            } else if (arg instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)arg;
                Gson gson3 = new Gson();
                jsonArray.forEach(elt -> {
                    TextEdit edit = (TextEdit)gson3.fromJson(gson3.toJson(elt), TextEdit.class);
                    if (edit != null) {
                        ((List)pair.value).add(edit);
                    }
                });
            } else if (arg instanceof JsonObject && (wEdit = (WorkspaceEdit)(gson = new Gson()).fromJson((JsonElement)(jsonObject = (JsonObject)arg), WorkspaceEdit.class)) != null) {
                Map entries = wEdit.getChanges();
                if (!entries.isEmpty()) {
                    changes.putAll(entries);
                } else {
                    TextEdit edit = (TextEdit)gson.fromJson((JsonElement)jsonObject, TextEdit.class);
                    if (edit != null && edit.getRange() != null) {
                        ((List)pair.value).add(edit);
                    }
                }
            }
        });
        if (!((List)currentEntry.value).isEmpty()) {
            changes.put(((URI)currentEntry.key).toASCIIString(), (List)currentEntry.value);
        }
        return workspaceEdit;
    }

    private CommandExecutor() {
    }

    private static final class Pair<K, V> {
        K key;
        V value;

        Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

