package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Immutable implementation of {@link UnlockKey}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUnlockKey.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableUnlockKey implements UnlockKey {
  private final String unlockKey;

  private ImmutableUnlockKey(String unlockKey) {
    this.unlockKey = unlockKey;
  }

  /**
   * @return The value of the {@code unlockKey} attribute
   */
  @JsonProperty("UnlockKey")
  @Override
  public String unlockKey() {
    return unlockKey;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UnlockKey#unlockKey() unlockKey} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for unlockKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUnlockKey withUnlockKey(String value) {
    String newValue = Objects.requireNonNull(value, "unlockKey");
    if (this.unlockKey.equals(newValue)) return this;
    return new ImmutableUnlockKey(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUnlockKey} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUnlockKey
        && equalTo(0, (ImmutableUnlockKey) another);
  }

  private boolean equalTo(int synthetic, ImmutableUnlockKey another) {
    return unlockKey.equals(another.unlockKey);
  }

  /**
   * Computes a hash code from attributes: {@code unlockKey}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + unlockKey.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UnlockKey} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UnlockKey{"
        + "unlockKey=" + unlockKey
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link UnlockKey} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UnlockKey instance
   */
  public static ImmutableUnlockKey copyOf(UnlockKey instance) {
    if (instance instanceof ImmutableUnlockKey) {
      return (ImmutableUnlockKey) instance;
    }
    return ImmutableUnlockKey.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUnlockKey ImmutableUnlockKey}.
   * <pre>
   * ImmutableUnlockKey.builder()
   *    .unlockKey(String) // required {@link UnlockKey#unlockKey() unlockKey}
   *    .build();
   * </pre>
   * @return A new ImmutableUnlockKey builder
   */
  public static ImmutableUnlockKey.Builder builder() {
    return new ImmutableUnlockKey.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUnlockKey ImmutableUnlockKey}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_UNLOCK_KEY = 0x1L;
    private long initBits = 0x1L;

    private String unlockKey;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnlockKey} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UnlockKey instance) {
      Objects.requireNonNull(instance, "instance");
      this.unlockKey(instance.unlockKey());
      return this;
    }

    /**
     * Initializes the value for the {@link UnlockKey#unlockKey() unlockKey} attribute.
     * @param unlockKey The value for unlockKey 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("UnlockKey")
    public final Builder unlockKey(String unlockKey) {
      this.unlockKey = Objects.requireNonNull(unlockKey, "unlockKey");
      initBits &= ~INIT_BIT_UNLOCK_KEY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUnlockKey ImmutableUnlockKey}.
     * @return An immutable instance of UnlockKey
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUnlockKey build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUnlockKey(unlockKey);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_UNLOCK_KEY) != 0) attributes.add("unlockKey");
      return "Cannot build UnlockKey, some of required attributes are not set " + attributes;
    }
  }
}
