/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.seproxy.plugin;

import java.util.Map;
import org.eclipse.keyple.seproxy.event.PluginEvent;
import org.eclipse.keyple.seproxy.event.ReaderEvent;
import org.eclipse.keyple.seproxy.exception.KeypleBaseException;
import org.eclipse.keyple.seproxy.plugin.AbstractObservablePlugin;
import org.eclipse.keyple.seproxy.plugin.AbstractObservableReader;
import org.eclipse.keyple.util.Configurable;
import org.eclipse.keyple.util.Nameable;
import org.eclipse.keyple.util.Observable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLoggedObservable<T>
extends Observable<T>
implements Nameable,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLoggedObservable.class);
    protected final String name;

    AbstractLoggedObservable(String name) {
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void addObserver(Observable.Observer<T> observer) {
        logger.trace("[{}][{}] addObserver => Adding an observer.", this.getClass(), (Object)this.getName());
        super.addObserver(observer);
    }

    @Override
    public void removeObserver(Observable.Observer<T> observer) {
        if (this instanceof AbstractObservableReader) {
            logger.trace("[{}] removeObserver => Deleting a reader observer", (Object)this.getName());
        } else if (this instanceof AbstractObservablePlugin) {
            logger.trace("[{}] removeObserver => Deleting a plugin observer", (Object)this.getName());
        }
        super.removeObserver(observer);
    }

    @Override
    public final void notifyObservers(T event) {
        if (this instanceof AbstractObservableReader) {
            logger.trace("[{}] AbstractObservableReader => Notifying a reader event to {} observers. EVENTNAME = {}", new Object[]{this.getName(), this.countObservers(), ((ReaderEvent)event).getEventType().getName()});
        } else if (this instanceof AbstractObservablePlugin) {
            logger.trace("[{}] AbstractObservableReader => Notifying a plugin event to {} observers. EVENTNAME = {} ", new Object[]{this.getName(), this.countObservers(), ((PluginEvent)event).getEventType().getName()});
        }
        this.setChanged();
        super.notifyObservers(event);
    }

    @Override
    public final void setParameters(Map<String, String> parameters) throws IllegalArgumentException, KeypleBaseException {
        for (Map.Entry<String, String> en : parameters.entrySet()) {
            this.setParameter(en.getKey(), en.getValue());
        }
    }
}

