/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.seproxy.message;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.keyple.util.ByteArrayUtils;

public final class ApduResponse
implements Serializable {
    static final long serialVersionUID = 6418469841122636812L;
    private final boolean successful;
    private final byte[] bytes;

    public ApduResponse(byte[] buffer, Set<Integer> successfulStatusCodes) throws IllegalArgumentException {
        this.bytes = buffer;
        if (buffer == null) {
            this.successful = false;
        } else {
            if (buffer.length < 2) {
                throw new IllegalArgumentException("Building an ApduResponse with a illegal buffer (length must be > 2): " + buffer.length);
            }
            int statusCode = ((buffer[buffer.length - 2] & 0xFF) << 8) + (buffer[buffer.length - 1] & 0xFF);
            if (statusCode < 0) {
                statusCode += 65536;
            }
            this.successful = successfulStatusCodes != null ? statusCode == 36864 || successfulStatusCodes.contains(statusCode) : statusCode == 36864;
        }
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public int getStatusCode() {
        int s = ((this.bytes[this.bytes.length - 2] & 0xFF) << 8) + (this.bytes[this.bytes.length - 1] & 0xFF);
        if (s < 0) {
            s += 65536;
        }
        return s;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte[] getDataOut() {
        return Arrays.copyOfRange(this.bytes, 0, this.bytes.length - 2);
    }

    public String toString() {
        String prefix = this.isSuccessful() ? "ApduResponse: SUCCESS, RAWDATA = " : "ApduResponse: FAILURE, RAWDATA = ";
        return prefix + ByteArrayUtils.toHex(this.bytes);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApduResponse)) {
            return false;
        }
        ApduResponse resp = (ApduResponse)o;
        return Arrays.equals(resp.getBytes(), this.bytes) && resp.isSuccessful() == this.successful;
    }

    public int hashCode() {
        int hash = 17;
        hash = 19 * hash + (this.successful ? 0 : 1);
        hash = 31 * hash + (this.bytes == null ? 0 : Arrays.hashCode(this.bytes));
        return hash;
    }
}

