/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.seproxy;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.keyple.util.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeSelector {
    private static final Logger logger = LoggerFactory.getLogger(SeSelector.class);
    private final AidSelector aidSelector;
    private final AtrFilter atrFilter;
    private final String extraInfo;

    public SeSelector(AidSelector aidSelector, AtrFilter atrFilter, String extraInfo) {
        this.aidSelector = aidSelector;
        this.atrFilter = atrFilter;
        this.extraInfo = extraInfo != null ? extraInfo : "";
        if (logger.isTraceEnabled()) {
            logger.trace("Selection data: AID = {}, ATRREGEX = {}, EXTRAINFO = {}", new Object[]{this.aidSelector == null ? "null" : ByteArrayUtils.toHex(this.aidSelector.getAidToSelect()), this.atrFilter == null ? "null" : this.atrFilter.getAtrRegex(), extraInfo});
        }
    }

    public AidSelector getAidSelector() {
        return this.aidSelector;
    }

    public AtrFilter getAtrFilter() {
        return this.atrFilter;
    }

    public final String getExtraInfo() {
        return this.extraInfo;
    }

    public String toString() {
        return "SeSelector: AID_SELECTOR = " + (this.aidSelector == null ? "null" : this.aidSelector.toString()) + ", ATR_FILTER = " + (this.atrFilter == null ? "null" : this.atrFilter.toString());
    }

    public static class AtrFilter {
        private String atrRegex;

        public AtrFilter(String atrRegex) {
            this.atrRegex = atrRegex;
        }

        public String getAtrRegex() {
            return this.atrRegex;
        }

        public boolean atrMatches(byte[] atr) {
            boolean m;
            if (this.atrRegex.length() != 0) {
                Pattern p = Pattern.compile(this.atrRegex);
                String atrString = ByteArrayUtils.toHex(atr);
                m = p.matcher(atrString).matches();
            } else {
                m = true;
            }
            return m;
        }

        public String toString() {
            return String.format("ATR regex:%s", this.atrRegex.length() != 0 ? this.atrRegex : "empty");
        }
    }

    public static class AidSelector {
        public static final int AID_MIN_LENGTH = 5;
        public static final int AID_MAX_LENGTH = 16;
        private FileOccurrence fileOccurrence = FileOccurrence.FIRST;
        private FileControlInformation fileControlInformation = FileControlInformation.FCI;
        private byte[] aidToSelect;
        private Set<Integer> successfulSelectionStatusCodes = new LinkedHashSet<Integer>();

        public AidSelector(byte[] aidToSelect, Set<Integer> successfulSelectionStatusCodes, FileOccurrence fileOccurrence, FileControlInformation fileControlInformation) {
            if (aidToSelect == null || aidToSelect.length < 5 || aidToSelect.length > 16) {
                throw new IllegalArgumentException("Bad AID value: must be between 5 and 5 bytes.");
            }
            this.aidToSelect = aidToSelect;
            this.successfulSelectionStatusCodes = successfulSelectionStatusCodes;
            this.fileOccurrence = fileOccurrence;
            this.fileControlInformation = fileControlInformation;
        }

        public AidSelector(byte[] aidToSelect, Set<Integer> successfulSelectionStatusCodes) {
            this(aidToSelect, successfulSelectionStatusCodes, FileOccurrence.FIRST, FileControlInformation.FCI);
        }

        public byte[] getAidToSelect() {
            return this.aidToSelect;
        }

        public boolean isSelectNext() {
            return this.fileOccurrence == FileOccurrence.NEXT;
        }

        public Set<Integer> getSuccessfulSelectionStatusCodes() {
            return this.successfulSelectionStatusCodes;
        }

        public String toString() {
            return String.format("AID:%s", this.aidToSelect == null ? "null" : ByteArrayUtils.toHex(this.aidToSelect));
        }

        public static enum FileControlInformation {
            FCI,
            FCP,
            FMD,
            NO_RESPONSE;

        }

        public static enum FileOccurrence {
            FIRST,
            LAST,
            NEXT,
            PREVIOUS;

        }
    }
}

