/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.PoCustomModificationCommandBuilder;
import org.eclipse.keyple.calypso.command.po.PoCustomReadCommandBuilder;
import org.eclipse.keyple.calypso.command.po.builder.ReadRecordsCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.SelectFileCmdBuild;
import org.eclipse.keyple.calypso.command.po.parser.ReadDataStructure;
import org.eclipse.keyple.calypso.command.po.parser.ReadRecordsRespPars;
import org.eclipse.keyple.calypso.command.po.parser.SelectFileRespPars;
import org.eclipse.keyple.calypso.transaction.CalypsoPo;
import org.eclipse.keyple.command.AbstractApduResponseParser;
import org.eclipse.keyple.seproxy.ChannelState;
import org.eclipse.keyple.seproxy.SeSelector;
import org.eclipse.keyple.seproxy.message.ApduRequest;
import org.eclipse.keyple.seproxy.message.ApduResponse;
import org.eclipse.keyple.seproxy.message.SeResponse;
import org.eclipse.keyple.seproxy.protocol.ContactsProtocols;
import org.eclipse.keyple.seproxy.protocol.SeProtocol;
import org.eclipse.keyple.transaction.SeSelectionRequest;
import org.eclipse.keyple.util.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PoSelectionRequest
extends SeSelectionRequest {
    private static final Logger logger = LoggerFactory.getLogger(PoSelectionRequest.class);
    private final PoClass poClass;
    private List<AbstractApduResponseParser> poResponseParserList = new ArrayList<AbstractApduResponseParser>();

    public PoSelectionRequest(SeSelector seSelector, ChannelState channelState, SeProtocol protocolFlag) {
        super(seSelector, channelState, protocolFlag);
        this.setMatchingClass(CalypsoPo.class);
        this.setSelectionClass(PoSelectionRequest.class);
        this.poClass = seSelector.getAidSelector() == null ? PoClass.LEGACY : PoClass.ISO;
        if (logger.isTraceEnabled()) {
            logger.trace("Calypso {} selector", (Object)this.poClass);
        }
    }

    private ReadRecordsRespPars prepareReadRecordsCmdInternal(byte sfi, ReadDataStructure readDataStructureEnum, byte firstRecordNumber, int expectedLength, String extraInfo) {
        boolean readJustOneRecord = readDataStructureEnum != ReadDataStructure.MULTIPLE_RECORD_DATA;
        this.addApduRequest(new ReadRecordsCmdBuild(this.poClass, sfi, firstRecordNumber, readJustOneRecord, (byte)expectedLength, extraInfo).getApduRequest());
        if (logger.isTraceEnabled()) {
            logger.trace("ReadRecords: SFI = {}, RECNUMBER = {}, JUSTONE = {}, EXPECTEDLENGTH = {}", new Object[]{sfi, firstRecordNumber, readJustOneRecord, expectedLength});
        }
        ReadRecordsRespPars poResponseParser = new ReadRecordsRespPars(firstRecordNumber, readDataStructureEnum);
        this.poResponseParserList.add(poResponseParser);
        return poResponseParser;
    }

    public ReadRecordsRespPars prepareReadRecordsCmd(byte sfi, ReadDataStructure readDataStructureEnum, byte firstRecordNumber, int expectedLength, String extraInfo) {
        if (expectedLength < 1 || expectedLength > 250) {
            throw new IllegalArgumentException("Bad length.");
        }
        return this.prepareReadRecordsCmdInternal(sfi, readDataStructureEnum, firstRecordNumber, expectedLength, extraInfo);
    }

    public ReadRecordsRespPars prepareReadRecordsCmd(byte sfi, ReadDataStructure readDataStructureEnum, byte firstRecordNumber, String extraInfo) {
        if (this.protocolFlag == ContactsProtocols.PROTOCOL_ISO7816_3) {
            throw new IllegalArgumentException("In contacts mode, the expected length must be specified.");
        }
        return this.prepareReadRecordsCmdInternal(sfi, readDataStructureEnum, firstRecordNumber, 0, extraInfo);
    }

    public SelectFileRespPars prepareSelectFileDfCmd(byte[] path, String extraInfo) {
        this.addApduRequest(new SelectFileCmdBuild(this.poClass, SelectFileCmdBuild.SelectControl.PATH_FROM_MF, SelectFileCmdBuild.SelectOptions.FCI, path).getApduRequest());
        if (logger.isTraceEnabled()) {
            logger.trace("Select File: PATH = {}", (Object)ByteArrayUtils.toHex((byte[])path));
        }
        SelectFileRespPars poResponseParser = new SelectFileRespPars();
        this.poResponseParserList.add(poResponseParser);
        return poResponseParser;
    }

    public void preparePoCustomReadCmd(String name, ApduRequest apduRequest) {
        this.addApduRequest(new PoCustomReadCommandBuilder(name, apduRequest).getApduRequest());
        if (logger.isTraceEnabled()) {
            logger.trace("CustomReadCommand: APDUREQUEST = {}", (Object)apduRequest);
        }
    }

    public void preparePoCustomModificationCmd(String name, ApduRequest apduRequest) {
        this.addApduRequest(new PoCustomModificationCommandBuilder(name, apduRequest).getApduRequest());
        if (logger.isTraceEnabled()) {
            logger.trace("CustomModificationCommand: APDUREQUEST = {}", (Object)apduRequest);
        }
    }

    protected void updateParsersWithResponses(SeResponse seResponse) {
        if (this.poResponseParserList.size() != 0) {
            Iterator<AbstractApduResponseParser> parserIterator = this.poResponseParserList.iterator();
            for (ApduResponse apduResponse : seResponse.getApduResponses()) {
                if (!parserIterator.hasNext()) {
                    throw new IllegalStateException("Parsers list and responses list mismatch! ");
                }
                parserIterator.next().setApduResponse(apduResponse);
                if (apduResponse.isSuccessful()) continue;
            }
        }
    }
}

