/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.wizards.view.pages;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.wizards.WizardHelper;
import org.eclipse.jwt.we.misc.wizards.view.ViewConfWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityViewConfWizardPage
extends WizardPage {
    static final Logger logger = Logger.getLogger(ActivityViewConfWizardPage.class);
    private Button allActivities;
    private Button selectedActivities;
    private Table activityList;

    public ActivityViewConfWizardPage(String pageId, IWorkbench workbench) {
        super(pageId);
    }

    public EditingDomain getEditingDomain() {
        return (EditingDomain)GeneralHelper.getActiveInstance().getAdapter(EditingDomain.class);
    }

    public AdapterFactory getAdapterFactory() {
        return (AdapterFactory)GeneralHelper.getActiveInstance().getAdapter(AdapterFactory.class);
    }

    public ArrayList<Activity> getSelectedActivities() {
        ArrayList<Activity> result = new ArrayList<Activity>();
        if (this.allActivities.getSelection()) {
            TableItem[] tableItemArray = this.activityList.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                result.add((Activity)tableItem.getData());
                ++n2;
            }
        } else {
            TableItem[] tableItemArray = this.activityList.getItems();
            int n = tableItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                TableItem tableItem = tableItemArray[n3];
                if (tableItem.getChecked()) {
                    result.add((Activity)tableItem.getData());
                }
                ++n3;
            }
        }
        return result;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)WizardHelper.createData(4, 4, true, false, -1, -1));
        this.allActivities = new Button(composite, 16);
        this.allActivities.setLayoutData((Object)WizardHelper.createData(-1, -1, false, false, 1, 1));
        this.allActivities.setText(PluginProperties.wizards_ViewConfActivityAll_label);
        this.allActivities.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ActivityViewConfWizardPage.this.activityList.setEnabled(false);
            }
        });
        this.selectedActivities = new Button(composite, 16);
        this.selectedActivities.setLayoutData((Object)WizardHelper.createData(-1, -1, false, false, 1, 1));
        this.selectedActivities.setText(PluginProperties.wizards_ViewConfActivitySelected_label);
        this.selectedActivities.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ActivityViewConfWizardPage.this.activityList.setEnabled(true);
            }
        });
        this.activityList = new Table(composite, 32);
        this.activityList.setLayoutData((Object)WizardHelper.createData(-1, -1, false, false, 1, 1));
        this.activityList.setBackground(composite.getBackground());
        TreeIterator iter = EcoreUtil.getAllContents((EObject)((EObject)GeneralHelper.getActiveInstance().getModel()), (boolean)true);
        while (iter.hasNext()) {
            EObject eobject = (EObject)iter.next();
            if (!(eobject instanceof Activity)) continue;
            TableItem tableItem = new TableItem(this.activityList, 0);
            if (((Activity)eobject).getName() != null) {
                tableItem.setText(((Activity)eobject).getName());
            }
            tableItem.setData((Object)eobject);
        }
        this.allActivities.setSelection(true);
        this.activityList.setEnabled(false);
        this.setMessage(PluginProperties.wizards_ViewConfActivity_message);
        this.setControl((Control)composite);
        this.getShell().pack();
        WizardHelper.resizeDialog(this.getShell());
    }

    public IWizardPage getNextPage() {
        ((ViewConfWizard)this.getWizard()).disposePreview();
        return this.getWizard().getPage("preview");
    }

    public void dispose() {
        if (this.allActivities != null && !this.allActivities.isDisposed()) {
            this.allActivities.dispose();
            this.allActivities = null;
        }
        if (this.selectedActivities != null && !this.selectedActivities.isDisposed()) {
            this.selectedActivities.dispose();
            this.selectedActivities = null;
        }
        if (this.activityList != null && !this.activityList.isDisposed()) {
            this.activityList.dispose();
            this.activityList = null;
        }
        super.dispose();
    }
}

