/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jubula.client.core.utils.IParamValueToken;
import org.eclipse.jubula.client.core.utils.IParamValueValidator;
import org.eclipse.jubula.client.core.utils.LiteralToken;
import org.eclipse.jubula.client.core.utils.ParamValueConverter;
import org.eclipse.jubula.client.core.utils.RefToken;
import org.eclipse.jubula.client.core.utils.SimpleValueToken;
import org.eclipse.jubula.client.core.utils.VariableToken;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboParamValidator
implements IParamValueValidator {
    private String[] m_values;
    private boolean m_valuesAreCombinable;

    public ComboParamValidator(String[] values, boolean valuesAreCombinable) {
        this.m_values = values;
        this.m_valuesAreCombinable = valuesAreCombinable;
    }

    @Override
    public ParamValueConverter.ConvValidationState validateInput(List<IParamValueToken> tokens) {
        ParamValueConverter.ConvValidationState state = ParamValueConverter.ConvValidationState.valid;
        if (this.m_values.length == 0) {
            return state;
        }
        StringBuilder evalBuilder = new StringBuilder();
        for (IParamValueToken token : tokens) {
            if (token instanceof RefToken || token instanceof VariableToken) {
                return ParamValueConverter.ConvValidationState.valid;
            }
            if (token instanceof LiteralToken) {
                String value = token.getGuiString();
                evalBuilder.append(value.substring(1, value.length() - 1));
                continue;
            }
            if (!(token instanceof SimpleValueToken)) continue;
            evalBuilder.append(token.getGuiString());
        }
        String evalString = evalBuilder.toString();
        String[] evalArray = this.m_valuesAreCombinable ? evalString.split(" ") : new String[]{evalString};
        state = ParamValueConverter.ConvValidationState.valid;
        String[] stringArray = evalArray;
        int n = evalArray.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            if (!Arrays.asList(this.m_values).contains(val)) {
                if (tokens.size() > 0) {
                    tokens.get(0).setErrorKey(MessageIDs.E_NOT_SUPP_COMBO_ITEM);
                }
                state = ParamValueConverter.ConvValidationState.undecided;
                boolean couldMatch = false;
                String[] stringArray2 = this.m_values;
                int n3 = this.m_values.length;
                int n4 = 0;
                while (n4 < n3) {
                    String possibleValue = stringArray2[n4];
                    couldMatch |= possibleValue.startsWith(val);
                    ++n4;
                }
                if (!couldMatch) {
                    return ParamValueConverter.ConvValidationState.invalid;
                }
            }
            ++n2;
        }
        return state;
    }
}

