/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.preferences.database;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.persistence.DatabaseConnectionInfo;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnection;
import org.eclipse.jubula.client.core.preferences.database.H2ConnectionInfo;
import org.eclipse.jubula.client.core.preferences.database.MySQLConnectionInfo;
import org.eclipse.jubula.client.core.preferences.database.OracleConnectionInfo;
import org.eclipse.jubula.client.core.preferences.database.PostGreSQLConnectionInfo;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConnectionConverter {
    public static final String PREF_DATABASE_CONNECTIONS = "org.eclipse.jubula.client.preference.databaseConnections";
    public static final BidiMap CONNECTION_CLASS_LOOKUP = new DualHashBidiMap();
    private static final Logger LOG;
    private static final String CONNECTION_SEPARATOR = "\n\n";
    private static final String CONNECTION_SPLIT_REGEX;
    private static final String PROPERTY_SEPARATOR = "\n";
    private static final String PROPERTY_SPLIT_REGEX;

    static {
        CONNECTION_CLASS_LOOKUP.put((Object)"H2", H2ConnectionInfo.class);
        CONNECTION_CLASS_LOOKUP.put((Object)"Oracle", OracleConnectionInfo.class);
        CONNECTION_CLASS_LOOKUP.put((Object)"PostGreSQL", PostGreSQLConnectionInfo.class);
        CONNECTION_CLASS_LOOKUP.put((Object)"MySQL", MySQLConnectionInfo.class);
        LOG = LoggerFactory.getLogger(DatabaseConnectionConverter.class);
        CONNECTION_SPLIT_REGEX = Pattern.quote(CONNECTION_SEPARATOR);
        PROPERTY_SPLIT_REGEX = Pattern.quote(PROPERTY_SEPARATOR);
    }

    private DatabaseConnectionConverter() {
    }

    public static List<DatabaseConnection> computeAvailableConnections() {
        return DatabaseConnectionConverter.convert(Platform.getPreferencesService().getString("org.eclipse.jubula.client.core", PREF_DATABASE_CONNECTIONS, "", null));
    }

    public static List<DatabaseConnection> convert(String preferenceValue) {
        LinkedList<DatabaseConnection> connectionList = new LinkedList<DatabaseConnection>();
        if (StringUtils.isNotBlank((String)preferenceValue)) {
            String[] stringArray = preferenceValue.split(CONNECTION_SPLIT_REGEX);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String connection = stringArray[n2];
                String[] connInfo = connection.split(PROPERTY_SPLIT_REGEX);
                if (connInfo.length < 2 || connInfo.length % 2 != 0) {
                    LOG.error(NLS.bind((String)Messages.DatabaseConnectionInvalidPreferenceString, (Object)connection));
                } else {
                    HashMap<String, String> beanProps = new HashMap<String, String>();
                    int i = 2;
                    while (i < connInfo.length) {
                        beanProps.put(connInfo[i], connInfo[i + 1]);
                        i += 2;
                    }
                    Class infoClass = (Class)CONNECTION_CLASS_LOOKUP.get((Object)connInfo[0]);
                    if (infoClass == null) {
                        LOG.error(NLS.bind((String)Messages.DatabaseConnectionInvalidPreferenceString, (Object)connection));
                    } else {
                        try {
                            DatabaseConnectionInfo infoBean = (DatabaseConnectionInfo)infoClass.newInstance();
                            BeanUtils.populate((Object)infoBean, beanProps);
                            connectionList.add(new DatabaseConnection(connInfo[1], infoBean));
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InstantiationException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                ++n2;
            }
        }
        return connectionList;
    }

    public static String convert(DatabaseConnection[] elements) {
        return DatabaseConnectionConverter.serializeDatabaseList(elements);
    }

    private static String serializeDatabaseList(DatabaseConnection[] connections) {
        StringBuilder sb = new StringBuilder();
        DatabaseConnection[] databaseConnectionArray = connections;
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            DatabaseConnection conn = databaseConnectionArray[n2];
            sb.append(CONNECTION_CLASS_LOOKUP.getKey(conn.getConnectionInfo().getClass()));
            sb.append(PROPERTY_SEPARATOR);
            sb.append(DatabaseConnectionConverter.serialize(conn));
            sb.append(CONNECTION_SEPARATOR);
            ++n2;
        }
        return sb.toString();
    }

    private static String serialize(DatabaseConnection connection) {
        Validate.notNull((Object)connection);
        StringBuilder sb = new StringBuilder();
        sb.append(connection.getName()).append(PROPERTY_SEPARATOR);
        PropertyDescriptor[] propertyDescriptorArray = PropertyUtils.getPropertyDescriptors((Object)connection.getConnectionInfo());
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor propDesc = propertyDescriptorArray[n2];
            String propName = propDesc.getName();
            try {
                if (PropertyUtils.isWriteable((Object)connection.getConnectionInfo(), (String)propName)) {
                    sb.append(propName).append(PROPERTY_SEPARATOR).append(BeanUtils.getProperty((Object)connection.getConnectionInfo(), (String)propName)).append(PROPERTY_SEPARATOR);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

