/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.PoMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDataCubePM {
    private TestDataCubePM() {
    }

    public static List<ITestDataCubePO> computeReuser(IParameterInterfacePO tdc, EntityManager session) {
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery();
        Root from = query.from(PoMaker.getTestDataCubeClass());
        query.select((Selection)from).where((Expression)builder.isNotNull((Expression)from.get("hbmReferencedDataCube")));
        List queryResult = session.createQuery(query).getResultList();
        ArrayList<ITestDataCubePO> result = new ArrayList<ITestDataCubePO>();
        for (ITestDataCubePO pio : queryResult) {
            if (!TestDataCubePM.areEqual(pio.getReferencedDataCube(), tdc)) continue;
            result.add(pio);
        }
        return result;
    }

    public static List<IParamNodePO> computeParamNodeReuser(IParameterInterfacePO pioToSearch, EntityManager session, IProjectPO proj) {
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery();
        Root from = query.from(PoMaker.getTestCasePOClass());
        query.select((Selection)from).where((Expression)builder.equal((Expression)from.get("hbmParentProjectId"), (Object)proj.getId()));
        List queryResult = session.createQuery(query).getResultList();
        ArrayList<IParamNodePO> result = new ArrayList<IParamNodePO>();
        for (IParameterInterfacePO pio : queryResult) {
            IParamNodePO pn;
            if (!(pio instanceof IParamNodePO) || !TestDataCubePM.areEqual((pn = (IParamNodePO)pio).getReferencedDataCube(), pioToSearch)) continue;
            result.add(pn);
        }
        return result;
    }

    private static boolean areEqual(IParameterInterfacePO po1, IParameterInterfacePO po2) {
        if (po1 != null && po2 != null) {
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((Object)po1.getId(), (Object)po2.getId());
            return eb.isEquals();
        }
        return false;
    }
}

