/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.LockTimeoutException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jubula.client.core.businessprocess.progress.OperationCanceledUtil;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMObjectDeletedException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistenceManager {
    private static Logger log = LoggerFactory.getLogger(PersistenceManager.class);

    protected PersistenceManager() {
        log.debug("deprecated");
    }

    private static void handleDetailedPersistenceException(IPersistentObject obj, PersistenceException e) throws PMException, PMDirtyVersionException, PMAlreadyLockedException, OperationCanceledException {
        OperationCanceledUtil.checkForOperationCanceled((RuntimeException)((Object)e));
        String msg = null;
        String objName = null;
        objName = obj == null ? Messages.UnknownObject : obj.getName();
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
        if (e instanceof EntityNotFoundException) {
            msg = String.valueOf(objName) + " " + Messages.WasDeletedByAnotherTransaction + ".";
            log.debug(msg, (Throwable)e);
            throw new PMObjectDeletedException(obj, msg, MessageIDs.E_DELETED_OBJECT);
        }
        if (e instanceof OptimisticLockException) {
            msg = String.valueOf(objName) + " " + Messages.WasModifiedInDBDirtyVersion + ".";
            log.debug(msg, (Throwable)e);
            throw new PMDirtyVersionException(obj, msg, MessageIDs.E_STALE_OBJECT);
        }
        if (PersistenceManager.isLockException(e)) {
            msg = String.valueOf(objName) + " " + Messages.AlreadyLockedCurrentlyLockAttemptFailed + ".";
            log.debug(msg, (Throwable)e);
            throw new PMAlreadyLockedException(obj, msg, MessageIDs.E_OBJECT_IN_USE);
        }
        if (rootCause instanceof SQLException) {
            SQLException sqlException = (SQLException)rootCause;
            msg = sqlException.getMessage();
            log.debug(msg, (Throwable)e);
            throw new PMException(msg, MessageIDs.E_SQL_EXCEPTION);
        }
        msg = String.valueOf(Messages.GeneralDatabaseErrorFor) + " " + objName + ".";
        log.error(msg, (Throwable)e);
        throw new PMException(msg, MessageIDs.E_DATABASE_GENERAL);
    }

    private static boolean isLockException(PersistenceException e) {
        Throwable[] throwableArray = ExceptionUtils.getThrowables((Throwable)e);
        int n = throwableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Throwable cause = throwableArray[n2];
            if (cause instanceof PessimisticLockException || cause instanceof OptimisticLockException || cause instanceof LockTimeoutException) {
                return true;
            }
            if (cause instanceof SQLException && ((SQLException)cause).getSQLState() != null && ((SQLException)cause).getSQLState().startsWith("61000")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void handleDBExceptionForEditor(IPersistentObject obj, PersistenceException e, EditSupport editSupp) throws PMException {
        if (PersistenceManager.isLockException(e)) {
            editSupp.reinitializeEditSupport();
        } else if (e instanceof EntityNotFoundException) {
            editSupp.close();
        } else {
            editSupp.reloadEditSession();
        }
        PersistenceManager.handleDetailedPersistenceException(obj, e);
    }

    public static void handleDBExceptionForMasterSession(IPersistentObject obj, PersistenceException e) throws PMAlreadyLockedException, PMDirtyVersionException, PMException, ProjectDeletedException {
        GeneralStorage gs = GeneralStorage.getInstance();
        if (PersistenceManager.isLockException(e)) {
            gs.recoverSession();
        } else {
            gs.reloadMasterSession((IProgressMonitor)new NullProgressMonitor());
        }
        PersistenceManager.handleDetailedPersistenceException(obj, e);
    }

    public static void handleDBExceptionForAnySession(IPersistentObject obj, PersistenceException e, EntityManager s) throws PMException {
        Persistor.instance().dropSession(s);
        PersistenceManager.handleDetailedPersistenceException(obj, e);
    }
}

