/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.businessprocess.progress.ElementLoadedProgressListener;
import org.eclipse.jubula.client.core.businessprocess.progress.InsertProgressListener;
import org.eclipse.jubula.client.core.businessprocess.progress.RemoveProgressListener;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.persistence.PersistenceUtil;
import org.eclipse.jubula.client.core.utils.DependencyCheckerOp;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.persistence.annotations.BatchFetch;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.annotations.Index;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="NODE")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(discriminatorType=DiscriminatorType.CHAR, name="CLASS_ID")
@DiscriminatorValue(value="N")
@EntityListeners(value={ElementLoadedProgressListener.class, InsertProgressListener.class, RemoveProgressListener.class})
abstract class NodePO
implements INodePO,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject {
    private transient Long m_id = null;
    private transient String m_guid = null;
    private transient Integer m_version = null;
    private transient boolean m_isParentNodeSet = false;
    private boolean m_isGenerated;
    private boolean m_isActive = true;
    private transient String m_toolkitLevel = "";
    private String m_name;
    private INodePO m_parentNode = null;
    private Long m_parentProjectId = null;
    private List<INodePO> m_nodeList = new ArrayList<INodePO>();
    private String m_comment;
    private long m_timestamp = 0L;
    private Set<IProblem> m_problems = new HashSet<IProblem>(5);
    static final long serialVersionUID = -2735281294663026321L;
    protected transient Object _persistence_primaryKey;

    protected NodePO(String name, String guid, boolean isGenerated) {
        this.setName(name);
        this.setGuid(guid);
        this.setGenerated(isGenerated);
    }

    protected NodePO(String name, boolean isGenerated) {
        this(name, PersistenceUtil.generateGuid(), isGenerated);
    }

    NodePO() {
    }

    void setHbmNodeList(List<INodePO> nodeList) {
        this.m_nodeList = nodeList;
        this.m_isParentNodeSet = false;
    }

    @Override
    @Transient
    public String getName() {
        return this.getHbmName();
    }

    @Basic
    @Column(name="NAME", length=4000)
    private String getHbmName() {
        return this.m_name;
    }

    private void setHbmName(String name) {
        this.m_name = name;
    }

    @Override
    public void setName(String name) {
        this.setHbmName(name);
    }

    @Override
    @Transient
    public INodePO getParentNode() {
        return this.m_parentNode;
    }

    @Override
    public void setParentNode(INodePO parent) {
        this.m_parentNode = parent;
    }

    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, targetEntity=NodePO.class)
    @JoinTable(name="NODE_LIST", joinColumns={@JoinColumn(name="PARENT")}, inverseJoinColumns={@JoinColumn(name="CHILD")})
    @OrderColumn(name="IDX")
    @BatchFetch(value=BatchFetchType.JOIN)
    List<INodePO> getHbmNodeList() {
        return this.m_nodeList;
    }

    @Transient
    List<INodePO> getNodeList() {
        if (!this.m_isParentNodeSet) {
            List<INodePO> nodeList = this.getHbmNodeList();
            Iterator<INodePO> iterator = nodeList.iterator();
            while (iterator.hasNext()) {
                INodePO o;
                INodePO node = o = iterator.next();
                node.setParentNode(this);
            }
            this.m_isParentNodeSet = true;
        }
        return this.getHbmNodeList();
    }

    @Override
    @Transient
    public List<INodePO> getUnmodifiableNodeList() {
        return Collections.unmodifiableList(this.getNodeList());
    }

    @Basic
    @Column(name="COMM_TXT", length=4000)
    private String getHbmComment() {
        return this.m_comment;
    }

    @Override
    @Transient
    public String getComment() {
        return this.getHbmComment();
    }

    private void setHbmComment(String comment) {
        this.m_comment = comment;
    }

    @Override
    public void setComment(String comment) {
        this.setHbmComment(comment);
    }

    @Override
    public void addNode(INodePO childNode) {
        this.addNode(-1, childNode);
    }

    @Override
    public void addNode(int position, INodePO childNode) {
        if (position < 0 || position > this.getNodeList().size()) {
            this.getNodeList().add(childNode);
        } else {
            this.getNodeList().add(position, childNode);
        }
        childNode.setParentNode(this);
        this.setParentProjectIdForChildNode(childNode);
    }

    protected void setParentProjectIdForChildNode(INodePO childNode) {
        childNode.setParentProjectId(this.getParentProjectId());
    }

    @Override
    public void removeNode(INodePO childNode) {
        ((NodePO)childNode).removeMe(this);
    }

    protected void removeMe(INodePO parent) {
        ((NodePO)parent).getNodeList().remove(this);
        this.setParentNode(null);
    }

    @Override
    public void removeAllNodes() {
        Iterator<INodePO> iter = this.getNodeList().iterator();
        while (iter.hasNext()) {
            INodePO childNode = iter.next();
            childNode.setParentNode(null);
            iter.remove();
        }
    }

    @Override
    public int indexOf(INodePO node) {
        return this.getNodeList().indexOf(node);
    }

    @Override
    @Transient
    public boolean isValid() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.getGuid().hashCode();
    }

    @Override
    @Transient
    public Iterator<INodePO> getNodeListIterator() {
        List<INodePO> nodeList = Collections.unmodifiableList(this.getNodeList());
        return nodeList.iterator();
    }

    @Override
    @Transient
    public int getNodeListSize() {
        return this.getNodeList().size();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " " + "(" + this.getName() + ")";
    }

    @Override
    @Id
    @GeneratedValue
    public Long getId() {
        return this.m_id;
    }

    void setId(Long id) {
        this.m_id = id;
    }

    @Override
    @Version
    @Column(name="VERSION")
    public Integer getVersion() {
        return this.m_version;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    @Override
    @Basic
    @Column(name="GUID")
    @Index(name="PI_NODE_GUID")
    public String getGuid() {
        return this.m_guid;
    }

    private void setGuid(String guid) {
        this.m_guid = guid;
    }

    @Override
    public boolean hasCircularDependences(INodePO parent) {
        DependencyCheckerOp op = new DependencyCheckerOp(parent);
        TreeTraverser traverser = new TreeTraverser(this, op);
        traverser.traverse(true);
        return op.hasDependency();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NodePO) && !(obj instanceof INodePO)) {
            return false;
        }
        INodePO o = (INodePO)obj;
        return this.getGuid().equals(o.getGuid());
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return this.getHbmParentProjectId();
    }

    @Override
    @Transient
    public abstract Boolean isReused();

    @Override
    public void setParentProjectId(Long projectId) {
        this.setHbmParentProjectId(projectId);
        for (INodePO node : this.getHbmNodeList()) {
            node.setParentProjectId(projectId);
        }
    }

    @Basic
    @Column(name="PARENT_PROJ")
    @Index(name="PI_NODE_PARENT_PROJ")
    Long getHbmParentProjectId() {
        return this.m_parentProjectId;
    }

    void setHbmParentProjectId(Long projectId) {
        this.m_parentProjectId = projectId;
    }

    @Override
    @Transient
    public String getToolkitLevel() {
        return this.m_toolkitLevel;
    }

    @Override
    public void setToolkitLevel(String toolkitLevel) {
        this.m_toolkitLevel = toolkitLevel;
    }

    @Override
    @Basic
    public long getTimestamp() {
        return this.m_timestamp;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.m_timestamp = timestamp;
    }

    @Override
    @Basic(optional=false)
    @Column(name="IS_GENERATED")
    public boolean isGenerated() {
        return this.m_isGenerated;
    }

    @Override
    public void setGenerated(boolean isGenerated) {
        this.m_isGenerated = isGenerated;
    }

    @Override
    public void setActive(boolean isActive) {
        this.m_isActive = isActive;
    }

    @Override
    @Basic(optional=false)
    @Column(name="IS_ACTIVE")
    public boolean isActive() {
        return this.m_isActive;
    }

    @Override
    public boolean addProblem(IProblem problem) {
        if (this.isActive()) {
            return this.m_problems.add(problem);
        }
        return false;
    }

    @Override
    public boolean removeProblem(IProblem problem) {
        return this.m_problems.remove(problem);
    }

    @Override
    public Set<IProblem> getProblems() {
        return Collections.unmodifiableSet(this.m_problems);
    }

    public Object _persistence_post_clone() {
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new NodePO();
    }

    public Object _persistence_get(String string) {
        if (string == "id") {
            return this.id;
        }
        if (string == "guid") {
            return this.guid;
        }
        if (string == "timestamp") {
            return this.timestamp;
        }
        if (string == "hbmParentProjectId") {
            return this.hbmParentProjectId;
        }
        if (string == "generated") {
            return this.generated;
        }
        if (string == "hbmComment") {
            return this.hbmComment;
        }
        if (string == "hbmName") {
            return this.hbmName;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "hbmNodeList") {
            return this.hbmNodeList;
        }
        if (string == "version") {
            return this.version;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "guid") {
            this.guid = (String)object;
            return;
        }
        if (string == "timestamp") {
            this.timestamp = (Long)object;
            return;
        }
        if (string == "hbmParentProjectId") {
            this.hbmParentProjectId = (Long)object;
            return;
        }
        if (string == "generated") {
            this.generated = (Boolean)object;
            return;
        }
        if (string == "hbmComment") {
            this.hbmComment = (String)object;
            return;
        }
        if (string == "hbmName") {
            this.hbmName = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "hbmNodeList") {
            this.hbmNodeList = (List)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
    }
}

