/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.events;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;

public class InteractionEventDispatcher
implements DataEventDispatcher.IDataChangedListener {
    private static InteractionEventDispatcher instance;
    private Set<IProgrammableSelectionListener> m_progammableSelectionListeners = new HashSet<IProgrammableSelectionListener>();

    private InteractionEventDispatcher() {
        instance = this;
    }

    public void addIProgrammableSelectionListener(IProgrammableSelectionListener l) {
        this.m_progammableSelectionListeners.add(l);
    }

    public void removeIProgrammableSelectionListener(IProgrammableSelectionListener l) {
        this.m_progammableSelectionListeners.remove(l);
    }

    public void fireProgammableSelectionEvent(IStructuredSelection s) {
        HashSet<IProgrammableSelectionListener> stableListeners = new HashSet<IProgrammableSelectionListener>(this.m_progammableSelectionListeners);
        for (IProgrammableSelectionListener l : stableListeners) {
            l.processSelection(s);
        }
    }

    public static InteractionEventDispatcher getDefault() {
        if (instance == null) {
            instance = new InteractionEventDispatcher();
            DataEventDispatcher.getInstance().addDataChangedListener(instance, true);
        }
        return instance;
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            this.handleDataChanged(e.getPo(), e.getDataState());
            ++n2;
        }
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState) {
        if (dataState == DataEventDispatcher.DataState.Added) {
            this.fireProgammableSelectionEvent((IStructuredSelection)new StructuredSelection((Object)po));
        }
    }

    public static interface IProgrammableSelectionListener {
        public void processSelection(IStructuredSelection var1);
    }
}

