/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.compcheck;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemFactory;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;

public class ProblemPropagator {
    public static final IProblem ERROR_IN_CHILD = ProblemFactory.createProblem((IStatus)new Status(4, "org.eclipse.jubula.client.core", Messages.TooltipErrorInChildren));
    public static final IProblem WARNING_IN_CHILD = ProblemFactory.createProblem((IStatus)new Status(2, "org.eclipse.jubula.client.core", Messages.TooltipWarningInChildren));
    private static ProblemPropagator instance;

    private ProblemPropagator() {
    }

    public static ProblemPropagator getInstance() {
        if (instance == null) {
            instance = new ProblemPropagator();
        }
        return instance;
    }

    public void propagate() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project != null) {
            new TreeTraverser((INodePO)project, (ITreeNodeOperation<INodePO>)new ProblemPropagationOperation(), false, true).traverse(true);
        }
        DataEventDispatcher.getInstance().fireProblemPropagationFinished();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProblemPropagationOperation
    implements ITreeNodeOperation<INodePO> {
        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            node.removeProblem(ERROR_IN_CHILD);
            node.removeProblem(WARNING_IN_CHILD);
            return node.isActive();
        }

        @Override
        public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (ProblemFactory.hasProblem(node)) {
                this.setParentProblem(parent, ProblemFactory.getWorstProblem(node.getProblems()).getStatus().getSeverity());
            }
        }

        private void setParentProblem(INodePO node, int severity) {
            switch (severity) {
                case 4: {
                    node.addProblem(ERROR_IN_CHILD);
                    break;
                }
                case 2: {
                    node.addProblem(WARNING_IN_CHILD);
                    break;
                }
            }
        }
    }
}

