/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.eclipse.jubula.client.core.businessprocess.IXMLReportWriter;
import org.eclipse.jubula.client.core.businessprocess.TestResultBP;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlResultReportWriter
implements IXMLReportWriter {
    private static final Logger LOG = LoggerFactory.getLogger(HtmlResultReportWriter.class);
    private OutputStreamWriter m_writer;

    public HtmlResultReportWriter(OutputStreamWriter writer) {
        this.m_writer = writer;
    }

    public void write(Document document) {
        OutputFormat htmlFormat = OutputFormat.createCompactFormat();
        htmlFormat.setEncoding(this.m_writer.getEncoding());
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            TestResultBP trbp = TestResultBP.getInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(trbp.getXslFileURL().openStream()));
            DocumentSource source = new DocumentSource(document);
            DocumentResult result = new DocumentResult();
            transformer.transform((Source)source, (Result)result);
            Document transformedDoc = result.getDocument();
            XMLWriter htmlWriter = new XMLWriter((Writer)this.m_writer, htmlFormat);
            htmlWriter.write(transformedDoc);
        }
        catch (TransformerConfigurationException e1) {
            LOG.error(String.valueOf(Messages.ErrorFileWriting) + ".", (Throwable)e1);
        }
        catch (TransformerException e) {
            LOG.error(String.valueOf(Messages.ErrorFileWriting) + ".", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error(String.valueOf(Messages.ErrorFileWriting) + ".", (Throwable)e);
        }
    }
}

