/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.businessprocess.TestDataBP;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.businessprocess.importfilter.DataTable;
import org.eclipse.jubula.client.core.businessprocess.importfilter.ExcelImportFilter;
import org.eclipse.jubula.client.core.businessprocess.importfilter.IDataImportFilter;
import org.eclipse.jubula.client.core.businessprocess.importfilter.exceptions.DataReadException;
import org.eclipse.jubula.client.core.businessprocess.importfilter.exceptions.NoSupportForLocaleException;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.tools.exception.IncompleteDataException;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalTestDataBP {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalTestDataBP.class);
    private static File globalDataDir = new File(".");
    private List<IDataImportFilter> m_filter;
    private Map<File, DataTable> m_dataTableCache = new HashMap<File, DataTable>();
    private Map<IParamNodePO, ITDManager> m_tdManagerCache = new HashMap<IParamNodePO, ITDManager>();

    public ExternalTestDataBP() {
        this.m_filter = new ArrayList<IDataImportFilter>();
        this.m_filter.add(new ExcelImportFilter());
    }

    private ITDManager createFilledTDManager(File dataDir, String file, IParamNodePO node) throws JBException {
        ITDManager tdManager = this.m_tdManagerCache.get(node);
        if (tdManager != null) {
            return tdManager;
        }
        tdManager = PoMaker.createTDManagerPO(node);
        Locale locale = TestExecution.getInstance().getLocale();
        node.clearTestData();
        DataTable dataTable = this.createDataTable(dataDir, file, locale);
        tdManager = this.parseTable(dataTable, node, locale);
        this.m_tdManagerCache.put(node, tdManager);
        return tdManager;
    }

    private ITDManager createFilledTDManager(IParameterInterfacePO referencedDataCube, IParamNodePO node) {
        ITDManager tdManager = this.m_tdManagerCache.get(node);
        if (tdManager != null) {
            return tdManager;
        }
        tdManager = referencedDataCube.getDataManager();
        this.m_tdManagerCache.put(node, tdManager);
        return tdManager;
    }

    public DataTable createDataTable(File dataDir, String fileName, Locale locale) throws JBException {
        File dataFile = new File(dataDir, fileName);
        DataTable dataTable = this.m_dataTableCache.get(dataFile);
        if (dataTable != null) {
            return dataTable;
        }
        String dataFileName = String.valueOf(dataFile);
        try {
            IDataImportFilter filter = this.getFilterFromFileType(fileName);
            if (filter != null) {
                dataTable = filter.parse(dataDir, fileName, locale);
                this.m_dataTableCache.put(dataFile, dataTable);
                return dataTable;
            }
            LOG.error(String.valueOf(Messages.DataSource) + ":" + " " + "'" + dataFileName + "'" + " " + Messages.NotSupported);
            throw new JBException(NLS.bind((String)Messages.ErrorMessageNOT_SUPP_DATASOURCE, (Object)dataFileName), MessageIDs.E_NOT_SUPP_DATASOURCE);
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.valueOf(Messages.ErrorReadingFile) + ":" + " " + dataFileName, (Throwable)e);
            }
            throw new JBException(NLS.bind((String)Messages.ErrorMessageNOT_SUPP_DATASOURCE, (Object)dataFileName), MessageIDs.E_DATASOURCE_FILE_IO);
        }
        catch (DataReadException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.valueOf(Messages.ErrorReadingFile) + ":" + " " + dataFileName, (Throwable)e);
            }
            throw new JBException(NLS.bind((String)Messages.ErrorMessageDATASOURCE_READ_ERROR, (Object)dataFileName), MessageIDs.E_DATASOURCE_READ_ERROR);
        }
        catch (NoSupportForLocaleException noSupportForLocaleException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.valueOf(Messages.LocaleNotSupported) + ":" + " " + String.valueOf(locale) + " " + Messages.InDataSource + ":" + " " + dataFileName);
            }
            throw new JBException(NLS.bind((String)Messages.ErrorMessageDATASOURCE_LOCALE_NOTSUPPORTED, (Object[])new Object[]{locale.toString(), locale.getDisplayLanguage()}), MessageIDs.E_DATASOURCE_LOCALE_NOTSUPPORTED);
        }
    }

    private IDataImportFilter getFilterFromFileType(String file) {
        for (IDataImportFilter filter : this.m_filter) {
            String[] extensions;
            String[] stringArray = extensions = filter.getFileExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (extension != null && extension.length() > 0 && file.endsWith(extension)) {
                    return filter;
                }
                ++n2;
            }
        }
        return null;
    }

    private ITDManager parseTable(DataTable filledTable, IParameterInterfacePO paramPo, Locale locale) throws JBException {
        return this.parseTable(filledTable, paramPo, locale, false, false);
    }

    public ITDManager parseTable(DataTable filledTable, IParameterInterfacePO paramPo, Locale locale, boolean updateCellValues, boolean useParamInterfaceTDMan) throws JBException {
        ITDManager tdMan = useParamInterfaceTDMan ? paramPo.getDataManager() : PoMaker.createTDManagerPO(paramPo);
        ArrayList<String> paramNamesExcel = new ArrayList<String>();
        List<IParamDescriptionPO> paramNamesNode = paramPo.getParameterList();
        int rowCount = filledTable.getRowCount();
        int row = 0;
        while (row < rowCount) {
            int columnCount = filledTable.getColumnCount();
            int cellNr = 0;
            while (cellNr < columnCount) {
                String cellString = this.getTestDataForTDManager(filledTable, row, cellNr);
                if (row == 0) {
                    paramNamesExcel.add(cellString);
                } else {
                    IParamDescriptionPO desc = paramPo.getParameterForName((String)paramNamesExcel.get(cellNr));
                    if (desc != null) {
                        ITestDataPO testData;
                        int dataSetNo = row - 1;
                        if (updateCellValues) {
                            testData = tdMan.getCell(dataSetNo, desc);
                            testData.setValue(locale, cellString, GeneralStorage.getInstance().getProject());
                        } else {
                            testData = TestDataBP.instance().createEmptyTestData();
                            testData.setValue(locale, cellString, GeneralStorage.getInstance().getProject());
                        }
                        tdMan.updateCell(testData, dataSetNo, desc.getUniqueId());
                    }
                }
                ++cellNr;
            }
            ++row;
        }
        for (IParamDescriptionPO desc : paramNamesNode) {
            if (paramNamesExcel.contains(desc.getName())) continue;
            throw new JBException(NLS.bind((String)Messages.ErrorMessageDATASOURCE_MISSING_PARAMETER, (Object[])new Object[]{desc.getName(), paramPo.getName(), paramPo.getDataFile()}), MessageIDs.E_DATASOURCE_MISSING_PARAMETER);
        }
        if (rowCount == 1) {
            throw new JBException(Messages.ErrorMessageDATASOURCE_MISSING_VALUES, MessageIDs.E_DATASOURCE_MISSING_VALUES);
        }
        return tdMan;
    }

    private String getTestDataForTDManager(DataTable filledTable, int row, int column) throws IncompleteDataException {
        String cellString = filledTable.getData(row, column);
        if (cellString == null || cellString.length() == 0) {
            MessageIDs.getMessageObject((Integer)MessageIDs.E_DATASOURCE_CONTAIN_EMPTY_DATA).setDetails(new String[0]);
            throw new IncompleteDataException(String.valueOf(MessageIDs.getMessage((Integer)MessageIDs.E_DATASOURCE_CONTAIN_EMPTY_DATA)) + "\n" + NLS.bind((String)Messages.ErrorDetailDATASOURCE_CONTAIN_EMPTY_DATA, (Object[])new Object[]{row + 1, column + 1}), MessageIDs.E_DATASOURCE_CONTAIN_EMPTY_DATA);
        }
        return cellString;
    }

    public ITDManager getExternalCheckedTDManager(IParamNodePO paramNode) throws JBException {
        boolean isTestRunning = TestExecution.getInstance().getStartedTestSuite() != null && TestExecution.getInstance().getStartedTestSuite().isStarted() && TestExecution.getInstance().getConnectedAut() != null;
        return this.getExternalCheckedTDManager(paramNode, TestExecution.getInstance().getLocale(), isTestRunning);
    }

    public ITDManager getExternalCheckedTDManager(IParamNodePO paramNode, Locale locale, boolean retrieveExternalData) throws JBException {
        boolean usesReferencedDataCube;
        Validate.notNull((Object)paramNode);
        Validate.notNull((Object)locale);
        boolean usesExternalDataFile = StringUtils.isNotEmpty((String)paramNode.getDataFile());
        boolean bl = usesReferencedDataCube = paramNode.getReferencedDataCube() != null;
        if (!usesExternalDataFile && !usesReferencedDataCube) {
            return paramNode.getDataManager();
        }
        if (!retrieveExternalData) {
            ITDManager tdManager = PoMaker.createTDManagerPO(paramNode);
            return tdManager;
        }
        if (usesExternalDataFile) {
            return this.createFilledTDManager(globalDataDir, paramNode.getDataFile(), paramNode);
        }
        if (usesReferencedDataCube) {
            return this.createFilledTDManager(paramNode.getReferencedDataCube(), paramNode);
        }
        LOG.error(String.valueOf(Messages.UnknownSourceType) + ":" + " " + paramNode.getName());
        return null;
    }

    public void clearExternalData() {
        this.m_dataTableCache.clear();
        this.m_tdManagerCache.clear();
    }

    public static File getDataDir() {
        return globalDataDir;
    }

    public static void setDataDir(File dataDir) {
        globalDataDir = dataDir;
    }
}

