/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.javaexec;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.generator.api.FromSelector;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.api.support.BaseGenerator;
import org.eclipse.jkube.generator.javaexec.FatJarDetector;
import org.eclipse.jkube.generator.javaexec.MainClassDetector;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;

public class JavaExecGenerator
extends BaseGenerator {
    private static final String WEB_PORT_DEFAULT = "8080";
    private static final String JOLOKIA_PORT_DEFAULT = "8778";
    private static final String PROMETHEUS_PORT_DEFAULT = "9779";
    static final String JAVA_MAIN_CLASS_ENV_VAR = "JAVA_MAIN_CLASS";
    protected static final String JAVA_OPTIONS = "JAVA_OPTIONS";
    private static final String[][] JAVA_EXEC_MAVEN_PLUGINS = new String[][]{{"org.codehaus.mojo", "exec-maven-plugin"}, {"org.apache.maven.plugins", "maven-shade-plugin"}};
    private final FatJarDetector fatJarDetector = new FatJarDetector(this.getProject().getBuildPackageDirectory());
    private final MainClassDetector mainClassDetector;

    public JavaExecGenerator(GeneratorContext context) {
        this(context, "java-exec");
    }

    protected JavaExecGenerator(GeneratorContext context, String name) {
        this(context, name, JDK.DEFAULT);
    }

    protected JavaExecGenerator(GeneratorContext context, String name, JDK jdk) {
        super(context, name, (FromSelector)new FromSelector.Default(context, jdk.imagePrefix));
        this.mainClassDetector = new MainClassDetector(this.getConfig(Config.MAIN_CLASS), this.getProject().getOutputDirectory(), context.getLogger());
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        if (this.shouldAddGeneratedImageConfiguration(configs)) {
            if (this.getConfig(Config.MAIN_CLASS) != null) {
                return true;
            }
            for (String[] plugin : JAVA_EXEC_MAVEN_PLUGINS) {
                if (!JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)plugin[0], (String)plugin[1])) continue;
                return true;
            }
        }
        return false;
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs, boolean prePackagePhase) {
        ImageConfiguration.ImageConfigurationBuilder imageBuilder = ImageConfiguration.builder();
        imageBuilder.name(this.getImageName()).registry(this.getRegistry()).alias(this.getAlias()).build(this.initImageBuildConfiguration(prePackagePhase).build());
        configs.add(imageBuilder.build());
        return configs;
    }

    protected BuildConfiguration.BuildConfigurationBuilder initImageBuildConfiguration(boolean prePackagePhase) {
        BuildConfiguration.BuildConfigurationBuilder buildBuilder = BuildConfiguration.builder();
        this.addSchemaLabels(buildBuilder, this.log);
        this.addFrom(buildBuilder);
        if (!prePackagePhase) {
            buildBuilder.assembly(this.createAssembly());
        }
        this.getEnv(prePackagePhase).forEach((arg_0, arg_1) -> ((BuildConfiguration.BuildConfigurationBuilder)buildBuilder).putEnv(arg_0, arg_1));
        buildBuilder.putEnv("JAVA_APP_DIR", this.getConfig(Config.TARGET_DIR));
        this.addWebPort(buildBuilder);
        this.addJolokiaPort(buildBuilder);
        this.addPrometheusPort(buildBuilder);
        this.addLatestTagIfSnapshot(buildBuilder);
        this.addTagsFromConfig(buildBuilder);
        buildBuilder.workdir(this.getBuildWorkdir());
        buildBuilder.entryPoint(this.getBuildEntryPoint());
        return buildBuilder;
    }

    protected Map<String, String> getEnv(boolean prePackagePhase) {
        List<String> javaOptions;
        HashMap<String, String> ret = new HashMap<String, String>();
        if (!this.isFatJar()) {
            String mainClass = this.getConfig(Config.MAIN_CLASS);
            if (mainClass == null && (mainClass = this.mainClassDetector.getMainClass()) == null && !prePackagePhase) {
                throw new IllegalStateException("Cannot extract main class to startup");
            }
            if (mainClass != null) {
                this.log.verbose("Detected main class %s", new Object[]{mainClass});
                ret.put(JAVA_MAIN_CLASS_ENV_VAR, mainClass);
            }
        }
        if (!(javaOptions = this.getExtraJavaOptions()).isEmpty()) {
            ret.put(JAVA_OPTIONS, StringUtils.join(javaOptions.iterator(), (String)" "));
        }
        return ret;
    }

    protected List<String> getExtraJavaOptions() {
        return new ArrayList<String>();
    }

    protected AssemblyConfiguration createAssembly() {
        AssemblyConfiguration.AssemblyConfigurationBuilder builder = AssemblyConfiguration.builder();
        builder.name("deployments");
        builder.targetDir(this.getConfig(Config.TARGET_DIR));
        builder.excludeFinalOutputArtifact(this.isFatJar());
        builder.layer(this.createDefaultLayer());
        return builder.build();
    }

    private Assembly createDefaultLayer() {
        ArrayList<AssemblyFileSet> fileSets = new ArrayList<AssemblyFileSet>(this.addAdditionalFiles());
        FatJarDetector.Result fatJar = this.detectFatJar();
        if (this.isFatJar() && fatJar != null) {
            fileSets.add(JavaExecGenerator.getOutputDirectoryFileSet(fatJar, this.getProject()));
        } else {
            this.log.warn("No fat Jar detected, make sure your image assembly configuration contains all the required dependencies for your application to run.", new Object[0]);
        }
        return Assembly.builder().fileSets(fileSets).build();
    }

    protected List<AssemblyFileSet> addAdditionalFiles() {
        ArrayList<AssemblyFileSet> fileSets = new ArrayList<AssemblyFileSet>();
        fileSets.add(JavaExecGenerator.createFileSet("src/main/jkube-includes/bin", "bin", "0755"));
        fileSets.add(JavaExecGenerator.createFileSet("src/main/jkube-includes", ".", "0644"));
        return fileSets;
    }

    private static AssemblyFileSet getOutputDirectoryFileSet(FatJarDetector.Result fatJar, JavaProject project) {
        File buildDirectory = project.getBuildPackageDirectory();
        return AssemblyFileSet.builder().directory(FileUtil.getRelativePath((File)project.getBaseDirectory(), (File)buildDirectory)).include(FileUtil.getRelativePath((File)buildDirectory, (File)fatJar.getArchiveFile()).getPath()).outputDirectory(new File(".")).fileMode("0640").build();
    }

    protected static AssemblyFileSet createFileSet(String sourceDir, String outputDir, String fileMode) {
        return AssemblyFileSet.builder().directory(new File(sourceDir)).outputDirectory(new File(outputDir)).fileMode(fileMode).build();
    }

    protected boolean isFatJar() {
        return !this.hasMainClass() && this.detectFatJar() != null;
    }

    protected boolean hasMainClass() {
        return this.getConfig(Config.MAIN_CLASS) != null;
    }

    public FatJarDetector.Result detectFatJar() {
        return this.fatJarDetector.scan();
    }

    protected String getDefaultWebPort() {
        return WEB_PORT_DEFAULT;
    }

    protected String getDefaultJolokiaPort() {
        return JOLOKIA_PORT_DEFAULT;
    }

    protected String getDefaultPrometheusPort() {
        return PROMETHEUS_PORT_DEFAULT;
    }

    private void addWebPort(BuildConfiguration.BuildConfigurationBuilder buildConfigBuilder) {
        String webPort = this.getConfig(Config.WEB_PORT, this.getDefaultWebPort());
        if (JavaExecGenerator.isPortValid(webPort)) {
            buildConfigBuilder.port(webPort);
        }
    }

    private void addJolokiaPort(BuildConfiguration.BuildConfigurationBuilder buildConfigBuilder) {
        String jolokiaPort = this.getConfig(Config.JOLOKIA_PORT, this.getDefaultJolokiaPort());
        if (JavaExecGenerator.isPortValid(jolokiaPort)) {
            buildConfigBuilder.port(jolokiaPort);
        } else {
            buildConfigBuilder.putEnv("AB_JOLOKIA_OFF", "true");
        }
    }

    private void addPrometheusPort(BuildConfiguration.BuildConfigurationBuilder buildConfigBuilder) {
        String jolokiaPort = this.getConfig(Config.PROMETHEUS_PORT, this.getDefaultPrometheusPort());
        if (JavaExecGenerator.isPortValid(jolokiaPort)) {
            buildConfigBuilder.port(jolokiaPort);
        } else {
            buildConfigBuilder.putEnv("AB_PROMETHEUS_OFF", "true");
        }
    }

    protected static boolean isPortValid(String port) {
        return StringUtils.isNotBlank((CharSequence)port) && port.matches("\\d+") && Integer.parseInt(port) > 0;
    }

    protected String getBuildWorkdir() {
        return null;
    }

    protected Arguments getBuildEntryPoint() {
        return null;
    }

    public static enum Config implements Configs.Config
    {
        WEB_PORT("webPort", null),
        JOLOKIA_PORT("jolokiaPort", null),
        PROMETHEUS_PORT("prometheusPort", null),
        TARGET_DIR("targetDir", "/deployments"),
        MAIN_CLASS("mainClass", null);

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }

    protected static enum JDK {
        DEFAULT("java"),
        JDK_11("java11");

        final String imagePrefix;

        private JDK(String imagePrefix) {
            this.imagePrefix = imagePrefix;
        }
    }
}

