/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.unboundidds.extensions.NotificationSubscriptionDetails;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class NotificationDestinationDetails
implements Serializable {
    private static final long serialVersionUID = -6596207374277234834L;
    private final List<ASN1OctetString> details;
    private final List<NotificationSubscriptionDetails> subscriptions;
    private final String id;

    public NotificationDestinationDetails(String id, Collection<ASN1OctetString> details, Collection<NotificationSubscriptionDetails> subscriptions) {
        Validator.ensureNotNull(id);
        Validator.ensureNotNull(details);
        Validator.ensureFalse(details.isEmpty());
        this.id = id;
        this.details = Collections.unmodifiableList(new ArrayList<ASN1OctetString>(details));
        this.subscriptions = subscriptions == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<NotificationSubscriptionDetails>(subscriptions));
    }

    public String getID() {
        return this.id;
    }

    public List<ASN1OctetString> getDetails() {
        return this.details;
    }

    public List<NotificationSubscriptionDetails> getSubscriptions() {
        return this.subscriptions;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("NotificationDestination(id='");
        buffer.append(this.id);
        buffer.append("', subscriptionIDs={");
        Iterator<NotificationSubscriptionDetails> subscriptionIterator = this.subscriptions.iterator();
        while (subscriptionIterator.hasNext()) {
            buffer.append('\'');
            buffer.append(subscriptionIterator.next().getID());
            buffer.append('\'');
            if (!subscriptionIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

