/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific;

import java.util.Set;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.evm.api.ActivationLifeCycle;
import org.eclipse.incquery.runtime.evm.api.Job;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventRealm;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventSourceSpecification;
import org.eclipse.incquery.runtime.evm.specific.lifecycle.DefaultActivationLifeCycle;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;

public final class Rules {
    public static <Match extends IPatternMatch> RuleSpecification<Match> newSimpleMatcherRuleSpecification(IQuerySpecification<? extends IncQueryMatcher<Match>> querySpecification, ActivationLifeCycle lifecycle, Set<Job<Match>> jobs) {
        return new RuleSpecification(IncQueryEventRealm.createSourceSpecification(querySpecification), lifecycle, jobs);
    }

    public static <Match extends IPatternMatch> RuleSpecification<Match> newSimpleMatcherRuleSpecification(IQuerySpecification<? extends IncQueryMatcher<Match>> querySpecification, Set<Job<Match>> jobs) {
        return Rules.newSimpleMatcherRuleSpecification(querySpecification, (ActivationLifeCycle)DefaultActivationLifeCycle.DEFAULT, jobs);
    }

    public static <Match extends IPatternMatch> RuleSpecification<Match> newSimpleMatcherRuleSpecification(IncQueryMatcher<Match> matcher, ActivationLifeCycle lifecycle, Set<Job<Match>> jobs) {
        FavouredMatcherSourceSpecification<Match> sourceSpecification = new FavouredMatcherSourceSpecification<Match>(matcher);
        return new RuleSpecification<Match>(sourceSpecification, lifecycle, jobs);
    }

    private static final class FavouredMatcherSourceSpecification<Match extends IPatternMatch>
    extends IncQueryEventSourceSpecification<Match> {
        private final IncQueryMatcher<Match> matcher;

        public FavouredMatcherSourceSpecification(IncQueryMatcher<Match> matcher) {
            super(FavouredMatcherSourceSpecification.getQuerySpecification(matcher));
            this.matcher = matcher;
        }

        private static <Match extends IPatternMatch> IQuerySpecification<? extends IncQueryMatcher<Match>> getQuerySpecification(IncQueryMatcher<Match> matcher) {
            return QuerySpecificationRegistry.getOrCreateQuerySpecification((Pattern)matcher.getPattern());
        }

        @Override
        protected IncQueryMatcher<Match> getMatcher(IncQueryEngine engine) throws IncQueryException {
            if (this.matcher.getEngine().equals(engine)) {
                return this.matcher;
            }
            return super.getMatcher(engine);
        }
    }
}

