/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.quasitree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.IPatternMatcherContext;
import org.eclipse.incquery.runtime.matchers.planning.IQueryPlannerStrategy;
import org.eclipse.incquery.runtime.matchers.planning.QueryPlannerException;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.planning.SubPlanFactory;
import org.eclipse.incquery.runtime.matchers.planning.helpers.BuildHelper;
import org.eclipse.incquery.runtime.matchers.planning.operations.PApply;
import org.eclipse.incquery.runtime.matchers.planning.operations.PEnumerate;
import org.eclipse.incquery.runtime.matchers.planning.operations.PJoin;
import org.eclipse.incquery.runtime.matchers.planning.operations.POperation;
import org.eclipse.incquery.runtime.matchers.planning.operations.PProject;
import org.eclipse.incquery.runtime.matchers.planning.operations.PStart;
import org.eclipse.incquery.runtime.matchers.psystem.DeferredPConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.EnumerablePConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.rete.construction.RetePatternBuildException;
import org.eclipse.incquery.runtime.rete.construction.quasitree.JoinCandidate;
import org.eclipse.incquery.runtime.rete.construction.quasitree.JoinOrderingHeuristics;
import org.eclipse.incquery.runtime.rete.util.Options;

public class QuasiTreeLayout
implements IQueryPlannerStrategy {
    public SubPlan plan(PBody pSystem, IPatternMatcherContext context) throws QueryPlannerException {
        return new Scaffold(pSystem, context).run();
    }

    public class Scaffold {
        PBody pSystem;
        PQuery query;
        IPatternMatcherContext context;
        SubPlanFactory planFactory;
        Set<DeferredPConstraint> deferredConstraints = null;
        Set<EnumerablePConstraint> enumerableConstraints = null;
        Set<SubPlan> forefront = new LinkedHashSet<SubPlan>();

        Scaffold(PBody pSystem, IPatternMatcherContext context) {
            this.pSystem = pSystem;
            this.context = context;
            this.planFactory = new SubPlanFactory(pSystem);
            this.query = pSystem.getPattern();
        }

        public SubPlan run() throws QueryPlannerException {
            try {
                this.context.logDebug(String.format("%s: patternbody build started for %s", this.getClass().getSimpleName(), this.query.getFullyQualifiedName()));
                this.deferredConstraints = this.pSystem.getConstraintsOfType(DeferredPConstraint.class);
                this.enumerableConstraints = this.pSystem.getConstraintsOfType(EnumerablePConstraint.class);
                for (EnumerablePConstraint enumerable : this.enumerableConstraints) {
                    SubPlan plan = this.planFactory.createSubPlan((POperation)new PEnumerate(enumerable), new SubPlan[0]);
                    this.admitSubPlan(plan);
                }
                if (this.enumerableConstraints.isEmpty()) {
                    SubPlan plan = this.planFactory.createSubPlan((POperation)new PStart(new PVariable[0]), new SubPlan[0]);
                    this.admitSubPlan(plan);
                }
                while (this.forefront.size() > 1) {
                    List<JoinCandidate> candidates = this.generateJoinCandidates();
                    JoinOrderingHeuristics ordering = new JoinOrderingHeuristics();
                    JoinCandidate selectedJoin = Collections.min(candidates, ordering);
                    this.doJoin(selectedJoin);
                }
                assert (this.forefront.size() == 1);
                SubPlan preFinalPlan = this.forefront.iterator().next();
                SubPlan finalPlan = this.planFactory.createSubPlan((POperation)new PProject(this.pSystem.getSymbolicParameterVariables()), new SubPlan[]{preFinalPlan});
                BuildHelper.finalCheck((PBody)this.pSystem, (SubPlan)finalPlan, (IPatternMatcherContext)this.context);
                this.context.logDebug(String.format("%s: patternbody query plan concluded for %s as: %s", this.getClass().getSimpleName(), this.query.getFullyQualifiedName(), finalPlan.toLongString()));
                return finalPlan;
            }
            catch (RetePatternBuildException ex) {
                ex.setPatternDescription(this.query);
                throw ex;
            }
        }

        public List<JoinCandidate> generateJoinCandidates() {
            ArrayList<JoinCandidate> candidates = new ArrayList<JoinCandidate>();
            int bIndex = 0;
            for (SubPlan b : this.forefront) {
                int aIndex = 0;
                for (SubPlan a : this.forefront) {
                    if (aIndex++ >= bIndex) break;
                    SubPlan joinedPlan = this.planFactory.createSubPlan((POperation)new PJoin(), new SubPlan[]{a, b});
                    candidates.add(new JoinCandidate(joinedPlan));
                }
                ++bIndex;
            }
            return candidates;
        }

        private void admitSubPlan(SubPlan plan) throws QueryPlannerException {
            if (Options.planTrimOption != Options.PlanTrimOption.OFF && !plan.getAllEnforcedConstraints().containsAll(this.enumerableConstraints)) {
                SubPlan trimmed;
                plan = trimmed = BuildHelper.trimUnneccessaryVariables((SubPlanFactory)this.planFactory, (SubPlan)plan, (boolean)true);
            }
            for (DeferredPConstraint deferred : this.deferredConstraints) {
                if (plan.getAllEnforcedConstraints().contains(deferred) || !deferred.isReadyAt(plan, this.context)) continue;
                this.admitSubPlan(this.planFactory.createSubPlan((POperation)new PApply((PConstraint)deferred), new SubPlan[]{plan}));
                return;
            }
            this.forefront.add(plan);
        }

        private void doJoin(JoinCandidate selectedJoin) throws QueryPlannerException {
            this.forefront.remove(selectedJoin.getPrimary());
            this.forefront.remove(selectedJoin.getSecondary());
            this.admitSubPlan(selectedJoin.getJoinedPlan());
        }
    }
}

