/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.wizards;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.incquery.tooling.core.generator.genmodel.IEiqGenmodelProvider;
import org.eclipse.incquery.tooling.ui.wizards.NewEiqGenmodelPage;
import org.eclipse.incquery.tooling.ui.wizards.internal.operations.CompositeWorkspaceModifyOperation;
import org.eclipse.incquery.tooling.ui.wizards.internal.operations.CreateGenmodelOperation;
import org.eclipse.incquery.tooling.ui.wizards.internal.operations.CreateProjectOperation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class NewProjectWizard
extends Wizard
implements INewWizard {
    private WizardNewProjectCreationPage projectCreationPage;
    private NewEiqGenmodelPage genmodelPage;
    private IProject project;
    private IWorkbench workbench;
    private IWorkspace workspace;
    @Inject
    private IEiqGenmodelProvider genmodelProvider;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private Logger logger;

    public void addPages() {
        this.projectCreationPage = new WizardNewProjectCreationPage("NewIncQueryProject");
        this.projectCreationPage.setTitle("New EMF IncQuery Project");
        this.projectCreationPage.setDescription("Create a new EMF IncQuery project.");
        this.addPage((IWizardPage)this.projectCreationPage);
        this.genmodelPage = new NewEiqGenmodelPage(true);
        this.addPage((IWizardPage)this.genmodelPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.workspace = ResourcesPlugin.getWorkspace();
    }

    public boolean performFinish() {
        if (this.project != null) {
            return true;
        }
        IProject projectHandle = this.projectCreationPage.getProjectHandle();
        if (projectHandle.exists()) {
            return false;
        }
        URI projectURI = !this.projectCreationPage.useDefaults() ? this.projectCreationPage.getLocationURI() : null;
        IProjectDescription description = this.workspace.newProjectDescription(projectHandle.getName());
        description.setLocationURI(projectURI);
        WorkspaceModifyOperation op = null;
        if (this.genmodelPage.isCreateGenmodelChecked()) {
            ArrayList<String> genmodelDependencies = new ArrayList<String>();
            for (GenModel model : this.genmodelPage.getSelectedGenmodels()) {
                String modelPluginID = model.getModelPluginID();
                if (genmodelDependencies.contains(modelPluginID)) continue;
                genmodelDependencies.add(modelPluginID);
            }
            CreateProjectOperation projectOp = new CreateProjectOperation(projectHandle, description, genmodelDependencies);
            CreateGenmodelOperation genmodelOp = new CreateGenmodelOperation(projectHandle, this.genmodelPage.getSelectedGenmodels(), this.genmodelProvider, this.resourceSetProvider);
            op = new CompositeWorkspaceModifyOperation(new WorkspaceModifyOperation[]{projectOp, genmodelOp}, "Creating project");
        } else {
            op = new CreateProjectOperation(projectHandle, description, (List<String>)ImmutableList.of());
        }
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (projectHandle.exists()) {
                try {
                    projectHandle.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e1) {
                    this.logger.error((Object)"Cannot remove partially created EMF-IncQuery project.", (Throwable)e1);
                }
            }
            Throwable realException = e.getTargetException();
            this.logger.error((Object)("Cannot create EMF-IncQuery project: " + realException.getMessage()), realException);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        this.project = projectHandle;
        BasicNewProjectResourceWizard.selectAndReveal((IResource)this.project, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
        return true;
    }
}

