package org.eclipse.incquery.tooling.core.generator.jvmmodel;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternModel;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.tooling.core.generator.jvmmodel.JavadocInferrer;
import org.eclipse.incquery.tooling.core.generator.util.EMFJvmTypesBuilder;
import org.eclipse.incquery.tooling.core.generator.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * Model Inferrer for Pattern grouping. Infers a Group class for every PatternModel.
 */
@SuppressWarnings("all")
public class PatternGroupClassInferrer {
  @Inject
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  private IJvmModelAssociations _iJvmModelAssociations;
  
  @Inject
  private TypeReferences types;
  
  @Inject
  private JavadocInferrer _javadocInferrer;
  
  public JvmGenericType inferPatternGroup(final PatternModel model) {
    JvmGenericType _xblockexpression = null;
    {
      String _groupClassName = this.groupClassName(model);
      final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
          public void apply(final JvmGenericType it) {
            String _packageName = model.getPackageName();
            it.setPackageName(_packageName);
            it.setFinal(true);
            EList<JvmTypeReference> _superTypes = it.getSuperTypes();
            JvmTypeReference _newTypeRef = PatternGroupClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(model, BaseGeneratedPatternGroup.class);
            PatternGroupClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _newTypeRef);
          }
        };
      final JvmGenericType groupClass = this._eMFJvmTypesBuilder.toClass(model, _groupClassName, _function);
      CharSequence _javadocGroupClass = this._javadocInferrer.javadocGroupClass(model);
      String _string = _javadocGroupClass.toString();
      this._eMFJvmTypesBuilder.setDocumentation(groupClass, _string);
      EList<JvmMember> _members = groupClass.getMembers();
      JvmOperation _inferInstanceMethod = this.inferInstanceMethod(model, groupClass);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _inferInstanceMethod);
      EList<JvmMember> _members_1 = groupClass.getMembers();
      JvmField _inferInstanceField = this.inferInstanceField(model, groupClass);
      this._eMFJvmTypesBuilder.<JvmField>operator_add(_members_1, _inferInstanceField);
      EList<JvmMember> _members_2 = groupClass.getMembers();
      JvmConstructor _inferConstructor = this.inferConstructor(model);
      this._eMFJvmTypesBuilder.<JvmConstructor>operator_add(_members_2, _inferConstructor);
      _xblockexpression = (groupClass);
    }
    return _xblockexpression;
  }
  
  public String groupClassName(final PatternModel model) {
    final String fileName = this._eMFPatternLanguageJvmModelInferrerUtil.modelFileName(model);
    return StringExtensions.toFirstUpper(fileName);
  }
  
  public JvmField inferInstanceField(final PatternModel model, final JvmGenericType groupClass) {
    JvmParameterizedTypeReference _createTypeRef = this.types.createTypeRef(groupClass);
    final Procedure1<JvmField> _function = new Procedure1<JvmField>() {
        public void apply(final JvmField it) {
          it.setVisibility(JvmVisibility.PRIVATE);
          it.setStatic(true);
        }
      };
    JvmField _field = this._eMFJvmTypesBuilder.toField(model, "INSTANCE", _createTypeRef, _function);
    return _field;
  }
  
  public JvmOperation inferInstanceMethod(final PatternModel model, final JvmGenericType groupClass) {
    JvmOperation _xblockexpression = null;
    {
      final JvmTypeReference incQueryException = this._eMFJvmTypesBuilder.newTypeRef(model, IncQueryException.class);
      JvmParameterizedTypeReference _createTypeRef = this.types.createTypeRef(groupClass);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            CharSequence _javadocGroupClassInstanceMethod = PatternGroupClassInferrer.this._javadocInferrer.javadocGroupClassInstanceMethod(model);
            String _string = _javadocGroupClassInstanceMethod.toString();
            PatternGroupClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            it.setVisibility(JvmVisibility.PUBLIC);
            it.setStatic(true);
            EList<JvmTypeReference> _exceptions = it.getExceptions();
            PatternGroupClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, incQueryException);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                public void apply(final ITreeAppendable it) {
                  StringConcatenation _builder = new StringConcatenation();
                  _builder.append("if (INSTANCE == null) {");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append("INSTANCE = new ");
                  it.append(_builder);
                  it.append(groupClass);
                  StringConcatenation _builder_1 = new StringConcatenation();
                  _builder_1.append("();");
                  _builder_1.newLine();
                  _builder_1.append("}");
                  _builder_1.newLine();
                  _builder_1.append("return INSTANCE;");
                  _builder_1.newLine();
                  it.append(_builder_1);
                }
              };
            PatternGroupClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
      JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(model, "instance", _createTypeRef, _function);
      _xblockexpression = (_method);
    }
    return _xblockexpression;
  }
  
  public JvmConstructor inferConstructor(final PatternModel model) {
    JvmConstructor _xblockexpression = null;
    {
      final JvmTypeReference incQueryException = this._eMFJvmTypesBuilder.newTypeRef(model, IncQueryException.class);
      final HashSet<JvmTypeReference> matcherReferences = this.gatherMatchers(model);
      final Procedure1<JvmConstructor> _function = new Procedure1<JvmConstructor>() {
          public void apply(final JvmConstructor it) {
            it.setVisibility(JvmVisibility.PRIVATE);
            String _groupClassName = PatternGroupClassInferrer.this.groupClassName(model);
            it.setSimpleName(_groupClassName);
            EList<JvmTypeReference> _exceptions = it.getExceptions();
            PatternGroupClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, incQueryException);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                public void apply(final ITreeAppendable it) {
                  for (final JvmTypeReference matcherRef : matcherReferences) {
                    {
                      StringConcatenation _builder = new StringConcatenation();
                      _builder.append("querySpecifications.add(");
                      it.append(_builder);
                      PatternGroupClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.serialize(it, matcherRef, model);
                      StringConcatenation _builder_1 = new StringConcatenation();
                      _builder_1.append(".querySpecification());");
                      it.append(_builder_1);
                      it.newLine();
                    }
                  }
                }
              };
            PatternGroupClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
      JvmConstructor _constructor = this._eMFJvmTypesBuilder.toConstructor(model, _function);
      _xblockexpression = (_constructor);
    }
    return _xblockexpression;
  }
  
  public HashSet<JvmTypeReference> gatherMatchers(final PatternModel model) {
    HashSet<JvmTypeReference> _xblockexpression = null;
    {
      HashSet<JvmTypeReference> _hashSet = new HashSet<JvmTypeReference>();
      final HashSet<JvmTypeReference> result = _hashSet;
      EList<Pattern> _patterns = model.getPatterns();
      for (final Pattern pattern : _patterns) {
        boolean _isPrivate = CorePatternLanguageHelper.isPrivate(pattern);
        boolean _not = (!_isPrivate);
        if (_not) {
          final Set<EObject> jvmElements = this._iJvmModelAssociations.getJvmElements(pattern);
          final Function1<EObject,Boolean> _function = new Function1<EObject,Boolean>() {
              public Boolean apply(final EObject e) {
                return Boolean.valueOf((e instanceof JvmGenericType));
              }
            };
          final EObject matcherClass = IterableExtensions.<EObject>findFirst(jvmElements, _function);
          if ((matcherClass instanceof JvmGenericType)) {
            final JvmParameterizedTypeReference sourceElementRef = this.types.createTypeRef(((JvmGenericType) matcherClass));
            result.add(sourceElementRef);
          }
        }
      }
      _xblockexpression = (result);
    }
    return _xblockexpression;
  }
}
