/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.sources;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.incquery.viewers.runtime.model.Containment;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.model.listeners.AbstractViewerStateListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TreeContentProvider
extends AbstractViewerStateListener
implements ITreeContentProvider {
    AbstractTreeViewer viewer;
    ViewerState state;
    Item.RootItem filter = new Item.RootItem();

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Preconditions.checkArgument((boolean)(viewer instanceof AbstractTreeViewer));
        this.viewer = (AbstractTreeViewer)viewer;
        if (oldInput instanceof ViewerState) {
            ((ViewerState)oldInput).removeStateListener(this);
        }
        if (newInput instanceof ViewerState) {
            this.state = (ViewerState)newInput;
            this.state.addStateListener(this);
        } else if (newInput != null) {
            throw new IllegalArgumentException(String.format("Invalid input type %s for Tree Viewer.", newInput.getClass().getName()));
        }
    }

    public Object[] getElements(Object inputElement) {
        return Iterables.toArray((Iterable)Iterables.filter((Iterable)this.state.getItems(), (Predicate)this.filter), Item.class);
    }

    public Object[] getChildren(Object parentElement) {
        Collection<Item> children = this.state.getChildren((Item)parentElement);
        return children.toArray(new Object[children.size()]);
    }

    public Object getParent(Object element) {
        return this.state.getParent((Item)element);
    }

    public boolean hasChildren(Object element) {
        return !this.state.getChildren((Item)element).isEmpty();
    }

    @Override
    public void itemAppeared(Item item) {
        if (this.filter.apply(item)) {
            this.viewer.add(this.viewer.getInput(), (Object)item);
        }
    }

    @Override
    public void itemDisappeared(Item item) {
        this.viewer.remove((Object)item);
    }

    @Override
    public void containmentAppeared(Containment edge) {
        this.viewer.add((Object)edge.getSource(), (Object)edge.getTarget());
        this.viewer.setExpandedState((Object)edge.getSource(), true);
        this.viewer.refresh((Object)edge.getTarget());
    }

    @Override
    public void containmentDisappeared(Containment edge) {
        this.viewer.remove((Object)edge.getSource(), new Object[]{edge.getTarget()});
        this.viewer.refresh((Object)edge.getSource());
    }

    public void dispose() {
        if (this.state != null) {
            this.state.removeStateListener(this);
        }
    }
}

