/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.sources;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.model.listeners.AbstractViewerLabelListener;
import org.eclipse.incquery.viewers.runtime.model.listeners.IViewerLabelListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

public class QueryLabelProvider
extends LabelProvider {
    private IViewerLabelListener labelListener = new AbstractViewerLabelListener(){

        @Override
        public void labelUpdated(Item item, String newLabel) {
            QueryLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)QueryLabelProvider.this, (Object)item));
        }

        @Override
        public void labelUpdated(Edge edge, String newLabel) {
            QueryLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)QueryLabelProvider.this, (Object)edge));
        }
    };
    private ViewerState state;

    public QueryLabelProvider(ViewerState state) {
        this.state = state;
        state.addLabelListener(this.labelListener);
    }

    public String getText(Object element) {
        if (element instanceof Item) {
            IObservableValue value = ((Item)element).getLabel();
            return value.getValue().toString();
        }
        if (element instanceof Edge) {
            IObservableValue value = ((Edge)element).getLabel();
            return value.getValue().toString();
        }
        return "";
    }

    public void dispose() {
        this.state.removeLabelListener(this.labelListener);
        super.dispose();
    }
}

