package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.ClassifierParentsMatch;
import org.eclipse.uml2.uml.Classifier;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.classifierParents pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class ClassifierParentsProcessor implements IMatchProcessor<ClassifierParentsMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSelf the value of pattern parameter self in the currently processed match
   * @param pClassifier the value of pattern parameter classifier in the currently processed match
   * 
   */
  public abstract void process(final Classifier pSelf, final Classifier pClassifier);
  
  @Override
  public void process(final ClassifierParentsMatch match) {
    process(match.getSelf(), match.getClassifier());
  }
}
