package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Arrays;
import java.util.List;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.uml.derivedfeatures.util.StateIsComposite_0QuerySpecification;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;

/**
 * Pattern-specific match representation of the org.eclipse.incquery.uml.derivedfeatures.stateIsComposite_0 pattern,
 * to be used in conjunction with {@link StateIsComposite_0Matcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see StateIsComposite_0Matcher
 * @see StateIsComposite_0Processor
 * 
 */
@SuppressWarnings("all")
public abstract class StateIsComposite_0Match extends BasePatternMatch {
  private State fSelf;
  
  private Region fRegion;
  
  private static List<String> parameterNames = makeImmutableList("self", "region");
  
  private StateIsComposite_0Match(final State pSelf, final Region pRegion) {
    this.fSelf = pSelf;
    this.fRegion = pRegion;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("self".equals(parameterName)) return this.fSelf;
    if ("region".equals(parameterName)) return this.fRegion;
    return null;
  }
  
  public State getSelf() {
    return this.fSelf;
  }
  
  public Region getRegion() {
    return this.fRegion;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("self".equals(parameterName) ) {
    	this.fSelf = (org.eclipse.uml2.uml.State) newValue;
    	return true;
    }
    if ("region".equals(parameterName) ) {
    	this.fRegion = (org.eclipse.uml2.uml.Region) newValue;
    	return true;
    }
    return false;
  }
  
  public void setSelf(final State pSelf) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fSelf = pSelf;
  }
  
  public void setRegion(final Region pRegion) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fRegion = pRegion;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.incquery.uml.derivedfeatures.stateIsComposite_0";
  }
  
  @Override
  public List<String> parameterNames() {
    return StateIsComposite_0Match.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fSelf, fRegion};
  }
  
  @Override
  public StateIsComposite_0Match toImmutable() {
    return isMutable() ? newMatch(fSelf, fRegion) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"self\"=" + prettyPrintValue(fSelf) + ", ");
    
    result.append("\"region\"=" + prettyPrintValue(fRegion)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fSelf == null) ? 0 : fSelf.hashCode());
    result = prime * result + ((fRegion == null) ? 0 : fRegion.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof StateIsComposite_0Match)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    StateIsComposite_0Match other = (StateIsComposite_0Match) obj;
    if (fSelf == null) {if (other.fSelf != null) return false;}
    else if (!fSelf.equals(other.fSelf)) return false;
    if (fRegion == null) {if (other.fRegion != null) return false;}
    else if (!fRegion.equals(other.fRegion)) return false;
    return true;
  }
  
  @Override
  public StateIsComposite_0QuerySpecification specification() {
    try {
    	return StateIsComposite_0QuerySpecification.instance();
    } catch (IncQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static StateIsComposite_0Match newEmptyMatch() {
    return new Mutable(null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pRegion the fixed value of pattern parameter region, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static StateIsComposite_0Match newMutableMatch(final State pSelf, final Region pRegion) {
    return new Mutable(pSelf, pRegion);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pRegion the fixed value of pattern parameter region, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static StateIsComposite_0Match newMatch(final State pSelf, final Region pRegion) {
    return new Immutable(pSelf, pRegion);
  }
  
  private static final class Mutable extends StateIsComposite_0Match {
    Mutable(final State pSelf, final Region pRegion) {
      super(pSelf, pRegion);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends StateIsComposite_0Match {
    Immutable(final State pSelf, final Region pRegion) {
      super(pSelf, pRegion);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
