package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.uml.derivedfeatures.DeploymentTargetDeployedElementMatch;
import org.eclipse.incquery.uml.derivedfeatures.util.DeploymentTargetDeployedElementQuerySpecification;
import org.eclipse.uml2.uml.DeploymentTarget;
import org.eclipse.uml2.uml.PackageableElement;

/**
 * Generated pattern matcher API of the org.eclipse.incquery.uml.derivedfeatures.deploymentTargetDeployedElement pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link DeploymentTargetDeployedElementMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * (if connector.type = null 
 * then
 *   null 
 * else
 *   let index : Integer = connector.end-{@literal >}indexOf(self) in
 *     connector.type.memberEnd-{@literal >}at(index)
 * endif)
 * 
 * // Can't compile OCL to IncQuery because of org.eclipse.ocl.SemanticException: Unrecognized variable: (connector)
 * //{@literal @}Surrogate(feature = "definingEnd")
 * //pattern connectorEndDefiningEnd(source: ConnectorEnd, target: Property) {}
 * 
 * 
 * (deployment.deployedArtifact-{@literal >}select(oclIsKindOf(Artifact))-{@literal >}collect(oclAsType(Artifact).manifestation)-{@literal >}collect(utilizedElement)-{@literal >}asSet())
 * 
 * {@literal @}Surrogate(feature = "deployedElement")
 * {@literal @}QueryExplorer(checked = false)
 * pattern deploymentTargetDeployedElement(
 *     self : DeploymentTarget,
 *     packageableElement : PackageableElement
 * ) {
 *     Artifact(artifact);
 *     temp2 == artifact;
 *     DeploymentTarget.deployment(self, deployment);
 *     temp1 == deployment;
 *     Deployment.deployedArtifact(temp1, deployedArtifact);
 *     temp2 == deployedArtifact;
 *     temp3 == temp2;
 *     Artifact.manifestation(temp3, manifestation);
 *     temp4 == manifestation;
 *     Manifestation.utilizedElement(temp4, packageableElement);
 * }
 * </pre></code>
 * 
 * @see DeploymentTargetDeployedElementMatch
 * @see DeploymentTargetDeployedElementProcessor
 * @see DeploymentTargetDeployedElementQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class DeploymentTargetDeployedElementMatcher extends BaseMatcher<DeploymentTargetDeployedElementMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static DeploymentTargetDeployedElementMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    DeploymentTargetDeployedElementMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new DeploymentTargetDeployedElementMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_SELF = 0;
  
  private final static int POSITION_PACKAGEABLEELEMENT = 1;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(DeploymentTargetDeployedElementMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public DeploymentTargetDeployedElementMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public DeploymentTargetDeployedElementMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pPackageableElement the fixed value of pattern parameter packageableElement, or null if not bound.
   * @return matches represented as a DeploymentTargetDeployedElementMatch object.
   * 
   */
  public Collection<DeploymentTargetDeployedElementMatch> getAllMatches(final DeploymentTarget pSelf, final PackageableElement pPackageableElement) {
    return rawGetAllMatches(new Object[]{pSelf, pPackageableElement});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pPackageableElement the fixed value of pattern parameter packageableElement, or null if not bound.
   * @return a match represented as a DeploymentTargetDeployedElementMatch object, or null if no match is found.
   * 
   */
  public DeploymentTargetDeployedElementMatch getOneArbitraryMatch(final DeploymentTarget pSelf, final PackageableElement pPackageableElement) {
    return rawGetOneArbitraryMatch(new Object[]{pSelf, pPackageableElement});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pPackageableElement the fixed value of pattern parameter packageableElement, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final DeploymentTarget pSelf, final PackageableElement pPackageableElement) {
    return rawHasMatch(new Object[]{pSelf, pPackageableElement});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pPackageableElement the fixed value of pattern parameter packageableElement, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final DeploymentTarget pSelf, final PackageableElement pPackageableElement) {
    return rawCountMatches(new Object[]{pSelf, pPackageableElement});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pPackageableElement the fixed value of pattern parameter packageableElement, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final DeploymentTarget pSelf, final PackageableElement pPackageableElement, final IMatchProcessor<? super DeploymentTargetDeployedElementMatch> processor) {
    rawForEachMatch(new Object[]{pSelf, pPackageableElement}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pPackageableElement the fixed value of pattern parameter packageableElement, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final DeploymentTarget pSelf, final PackageableElement pPackageableElement, final IMatchProcessor<? super DeploymentTargetDeployedElementMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pSelf, pPackageableElement}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pPackageableElement the fixed value of pattern parameter packageableElement, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public DeploymentTargetDeployedElementMatch newMatch(final DeploymentTarget pSelf, final PackageableElement pPackageableElement) {
    return DeploymentTargetDeployedElementMatch.newMatch(pSelf, pPackageableElement);
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<DeploymentTarget> rawAccumulateAllValuesOfself(final Object[] parameters) {
    Set<DeploymentTarget> results = new HashSet<DeploymentTarget>();
    rawAccumulateAllValues(POSITION_SELF, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<DeploymentTarget> getAllValuesOfself() {
    return rawAccumulateAllValuesOfself(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<DeploymentTarget> getAllValuesOfself(final DeploymentTargetDeployedElementMatch partialMatch) {
    return rawAccumulateAllValuesOfself(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<DeploymentTarget> getAllValuesOfself(final PackageableElement pPackageableElement) {
    return rawAccumulateAllValuesOfself(new Object[]{
    null, 
    pPackageableElement
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for packageableElement.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<PackageableElement> rawAccumulateAllValuesOfpackageableElement(final Object[] parameters) {
    Set<PackageableElement> results = new HashSet<PackageableElement>();
    rawAccumulateAllValues(POSITION_PACKAGEABLEELEMENT, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for packageableElement.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<PackageableElement> getAllValuesOfpackageableElement() {
    return rawAccumulateAllValuesOfpackageableElement(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for packageableElement.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<PackageableElement> getAllValuesOfpackageableElement(final DeploymentTargetDeployedElementMatch partialMatch) {
    return rawAccumulateAllValuesOfpackageableElement(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for packageableElement.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<PackageableElement> getAllValuesOfpackageableElement(final DeploymentTarget pSelf) {
    return rawAccumulateAllValuesOfpackageableElement(new Object[]{
    pSelf, 
    null
    });
  }
  
  @Override
  protected DeploymentTargetDeployedElementMatch tupleToMatch(final Tuple t) {
    try {
    	return DeploymentTargetDeployedElementMatch.newMatch((org.eclipse.uml2.uml.DeploymentTarget) t.get(POSITION_SELF), (org.eclipse.uml2.uml.PackageableElement) t.get(POSITION_PACKAGEABLEELEMENT));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected DeploymentTargetDeployedElementMatch arrayToMatch(final Object[] match) {
    try {
    	return DeploymentTargetDeployedElementMatch.newMatch((org.eclipse.uml2.uml.DeploymentTarget) match[POSITION_SELF], (org.eclipse.uml2.uml.PackageableElement) match[POSITION_PACKAGEABLEELEMENT]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected DeploymentTargetDeployedElementMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return DeploymentTargetDeployedElementMatch.newMutableMatch((org.eclipse.uml2.uml.DeploymentTarget) match[POSITION_SELF], (org.eclipse.uml2.uml.PackageableElement) match[POSITION_PACKAGEABLEELEMENT]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<DeploymentTargetDeployedElementMatcher> querySpecification() throws IncQueryException {
    return DeploymentTargetDeployedElementQuerySpecification.instance();
  }
}
