/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.handlers;

import com.google.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ModelConnectorTreeViewerKey;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatch;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatcher;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.ITextRegion;

public class ShowLocationHandler
extends AbstractHandler {
    @Inject
    private ILocationInFileProvider locationProvider;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof TreeSelection) {
            ObservablePatternMatcher matcher;
            Object obj = selection.getFirstElement();
            if (obj instanceof ObservablePatternMatch) {
                ObservablePatternMatch pm = (ObservablePatternMatch)obj;
                ModelConnectorTreeViewerKey key = pm.getParent().getParent().getKey();
                QueryExplorer.getInstance().getModelConnectorMap().get(key).showLocation(pm.getLocationObjects());
            } else if (obj instanceof ObservablePatternMatcher && (matcher = (ObservablePatternMatcher)obj).getMatcher() != null) {
                this.setSelectionToXTextEditor(matcher.getMatcher().getPattern());
            }
        }
        return null;
    }

    protected void setSelectionToXTextEditor(Pattern pattern) {
        IFile file = QueryExplorerPatternRegistry.getInstance().getFileForPattern(pattern);
        IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            String id = ref.getId();
            IEditorPart editor = ref.getEditor(true);
            if (id.equals("org.eclipse.incquery.patternlanguage.emf.EMFPatternLanguage")) {
                ITextRegion location;
                FileEditorInput editorInput;
                assert (editor instanceof XtextEditor);
                XtextEditor providerEditor = (XtextEditor)editor;
                IEditorInput input = providerEditor.getEditorInput();
                if (input instanceof FileEditorInput && (editorInput = (FileEditorInput)input).getFile().equals((Object)file)) {
                    editor.getSite().getPage().bringToTop((IWorkbenchPart)editor);
                }
                if ((location = this.locationProvider.getSignificantTextRegion((EObject)pattern)) != null) {
                    providerEditor.reveal(location.getOffset(), location.getLength());
                    providerEditor.getSelectionProvider().setSelection((ISelection)new TextSelection(location.getOffset(), location.getLength()));
                }
            }
            ++n2;
        }
    }
}

