/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.content.detail;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.incquery.databinding.runtime.adapter.DatabindingAdapter;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.detail.DetailComparator;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.detail.DetailElementCellModifier;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.detail.DetailElementLabelProvider;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.detail.DetailObserver;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.detail.MatcherConfiguration;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.detail.MatcherConfigurationCellModifier;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.detail.MatcherConfigurationContentProvider;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.detail.MatcherConfigurationLabelProvider;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.detail.ModelElementCellEditor;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatch;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatcher;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.DisplayUtil;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.xbase.typing.ITypeProvider;

@Singleton
public class TableViewerUtil {
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private Injector injector;
    private final Set<String> primitiveTypes = new HashSet<String>();

    protected TableViewerUtil() {
        this.primitiveTypes.add(Boolean.class.getName());
        this.primitiveTypes.add(Character.class.getName());
        this.primitiveTypes.add(Byte.class.getName());
        this.primitiveTypes.add(Short.class.getName());
        this.primitiveTypes.add(Integer.class.getName());
        this.primitiveTypes.add(Long.class.getName());
        this.primitiveTypes.add(Float.class.getName());
        this.primitiveTypes.add(Double.class.getName());
        this.primitiveTypes.add(Void.class.getName());
        this.primitiveTypes.add(String.class.getName());
    }

    public boolean isPrimitiveType(String fqn) {
        return this.primitiveTypes.contains(fqn);
    }

    public void prepareTableViewerForObservableInput(ObservablePatternMatch match, TableViewer viewer) {
        this.clearTableViewerColumns(viewer);
        String[] titles = new String[]{"Parameter", "Value"};
        this.createColumns(viewer, titles);
        viewer.setUseHashlookup(true);
        viewer.setColumnProperties(titles);
        viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DetailElementLabelProvider());
        viewer.setCellModifier((ICellModifier)new DetailElementCellModifier());
        viewer.setComparator(new ViewerComparator((Comparator)new DetailComparator(match.getPatternMatch().parameterNames())));
        DatabindingAdapter<IPatternMatch> databindableMatcher = DisplayUtil.getDatabindingAdapter(match.getPatternMatch().patternName());
        if (databindableMatcher == null) {
            viewer.setInput(null);
        } else {
            DetailObserver observer = new DetailObserver(databindableMatcher, match);
            viewer.setInput((Object)observer);
        }
    }

    public void prepareTableViewerForMatcherConfiguration(ObservablePatternMatcher observableMatcher, TableViewer viewer) {
        this.clearTableViewerColumns(viewer);
        String[] titles = new String[]{"Parameter", "Filter", "Class"};
        this.createColumns(viewer, titles);
        viewer.setUseHashlookup(true);
        viewer.setColumnProperties(titles);
        viewer.setContentProvider((IContentProvider)new MatcherConfigurationContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new MatcherConfigurationLabelProvider());
        viewer.setCellModifier((ICellModifier)new MatcherConfigurationCellModifier(viewer));
        viewer.setComparator(new ViewerComparator((Comparator)new DetailComparator(observableMatcher.getMatcher().getParameterNames())));
        Table table = viewer.getTable();
        CellEditor[] editors = new CellEditor[titles.length];
        editors[0] = new TextCellEditor((Composite)table);
        ModelElementCellEditor cellEditor = new ModelElementCellEditor(table, observableMatcher);
        this.injector.injectMembers((Object)cellEditor);
        editors[1] = cellEditor;
        editors[2] = new TextCellEditor((Composite)table);
        viewer.setCellEditors(editors);
        Pattern pattern = QueryExplorerPatternRegistry.getInstance().getPatternByFqn(observableMatcher.getPatternName());
        Object[] filter = observableMatcher.getFilter();
        MatcherConfiguration[] input = new MatcherConfiguration[pattern.getParameters().size()];
        if (filter != null) {
            int i = 0;
            while (i < pattern.getParameters().size()) {
                Variable var = (Variable)pattern.getParameters().get(i);
                String name = var.getName();
                JvmTypeReference ref = this.typeProvider.getTypeForIdentifiable((JvmIdentifiableElement)var);
                String clazz = ref == null || ref instanceof JvmUnknownTypeReference ? "" : ref.getType().getQualifiedName();
                input[i] = new MatcherConfiguration(name, clazz, filter[i]);
                ++i;
            }
            viewer.setInput((Object)input);
        }
    }

    public void clearTableViewerColumns(TableViewer viewer) {
        if (viewer.getContentProvider() != null) {
            viewer.setInput(null);
        }
        while (viewer.getTable().getColumnCount() > 0) {
            viewer.getTable().getColumns()[0].dispose();
        }
        viewer.refresh();
    }

    private void createColumns(TableViewer viewer, String[] titles) {
        int i = 0;
        while (i < titles.length) {
            this.createTableViewerColumn(viewer, titles[i], i);
            ++i;
        }
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int index) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0, index);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(true);
        column.setWidth(150);
        return viewerColumn;
    }

    public Object createValue(String classFqn, Object value) {
        if (!(value instanceof String)) {
            return value;
        }
        classFqn = classFqn.toLowerCase();
        String strValue = value.toString();
        if (strValue.matches("")) {
            return null;
        }
        if (Boolean.class.getName().toLowerCase().matches(classFqn)) {
            return Boolean.valueOf(strValue.toLowerCase());
        }
        if (Character.class.getName().toLowerCase().matches(classFqn)) {
            return Character.valueOf(strValue.charAt(0));
        }
        if (Byte.class.getName().toLowerCase().matches(classFqn)) {
            return Byte.valueOf(strValue);
        }
        if (Short.class.getName().toLowerCase().matches(classFqn)) {
            return Short.valueOf(strValue);
        }
        if (Integer.class.getName().toLowerCase().matches(classFqn)) {
            return Integer.valueOf(strValue);
        }
        if (Long.class.getName().toLowerCase().matches(classFqn)) {
            return Long.valueOf(strValue);
        }
        if (Float.class.getName().toLowerCase().matches(classFqn)) {
            return Float.valueOf(strValue);
        }
        if (Double.class.getName().toLowerCase().matches(classFqn)) {
            return Double.valueOf(strValue);
        }
        if (String.class.getName().toLowerCase().matches(classFqn)) {
            return value;
        }
        return null;
    }

    public boolean isValidValue(String classFqn, String value) {
        classFqn = classFqn.toLowerCase();
        if (Boolean.class.getName().toLowerCase().matches(classFqn)) {
            return value.toLowerCase().matches("true") || value.toLowerCase().matches("false");
        }
        if (Character.class.getName().toLowerCase().matches(classFqn)) {
            return true;
        }
        if (Byte.class.getName().toLowerCase().matches(classFqn) || Short.class.getName().toLowerCase().matches(classFqn) || Integer.class.getName().toLowerCase().matches(classFqn) || Long.class.getName().toLowerCase().matches(classFqn)) {
            return value.matches("[0-9]*");
        }
        if (Float.class.getName().toLowerCase().matches(classFqn) || Double.class.getName().toLowerCase().matches(classFqn)) {
            return value.matches("[0-9]*\\.?[0-9]*");
        }
        if (String.class.getName().toLowerCase().matches(classFqn)) {
            return true;
        }
        return true;
    }
}

