/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.api.impl;

import com.google.common.base.Preconditions;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.impl.BaseQuerySpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;

public abstract class BaseGeneratedQuerySpecification<Matcher extends IncQueryMatcher<? extends IPatternMatch>>
extends BaseQuerySpecification<Matcher> {
    public BaseGeneratedQuerySpecification() {
        this.ensureInitialized();
    }

    protected static void processInitializerError(ExceptionInInitializerError err) throws IncQueryException {
        Throwable cause2;
        Throwable cause1 = err.getCause();
        if (cause1 instanceof RuntimeException && (cause2 = ((RuntimeException)cause1).getCause()) instanceof IncQueryException) {
            throw (IncQueryException)cause2;
        }
    }

    protected EClassifier getClassifierLiteral(String packageUri, String classifierName) {
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(packageUri);
        Preconditions.checkState((ePackage != null ? 1 : 0) != 0, (String)"EPackage %s not found in EPackage Registry.", (Object[])new Object[]{packageUri});
        EClassifier literal = ePackage.getEClassifier(classifierName);
        Preconditions.checkState((literal != null ? 1 : 0) != 0, (String)"Classifier %s not found in EPackage %s", (Object[])new Object[]{classifierName, packageUri});
        return literal;
    }

    protected EStructuralFeature getFeatureLiteral(String packageUri, String className, String featureName) {
        EClassifier container = this.getClassifierLiteral(packageUri, className);
        Preconditions.checkState((boolean)(container instanceof EClass), (String)"Classifier %s in EPackage %s does not refer to an EClass.", (Object[])new Object[]{className, packageUri});
        EStructuralFeature feature = ((EClass)container).getEStructuralFeature(featureName);
        Preconditions.checkState((feature != null ? 1 : 0) != 0, (String)"Feature %s not found in EClass %s", (Object[])new Object[]{featureName, className});
        return feature;
    }

    protected EEnumLiteral getEnumLiteral(String packageUri, String enumName, String literalName) {
        EClassifier enumContainer = this.getClassifierLiteral(packageUri, enumName);
        Preconditions.checkState((boolean)(enumContainer instanceof EEnum), (String)"Classifier %s in EPackage %s is not an EEnum.", (Object[])new Object[]{enumName, packageUri});
        EEnumLiteral literal = ((EEnum)enumContainer).getEEnumLiteral(literalName);
        Preconditions.checkState((literal != null ? 1 : 0) != 0, (String)"Unknown literal %s in enum %s", (Object[])new Object[]{literalName, enumName});
        return literal;
    }
}

