/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.api;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.incquery.runtime.api.IQueryGroup;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.impl.BasePatternGroup;

public class GenericPatternGroup
extends BasePatternGroup {
    private final Set<IQuerySpecification<?>> patterns;

    public GenericPatternGroup(Set<IQuerySpecification<?>> patterns) {
        this.patterns = patterns;
    }

    @Override
    public Set<IQuerySpecification<?>> getSpecifications() {
        return this.patterns;
    }

    public static IQueryGroup of(Set<IQuerySpecification<?>> querySpecifications) {
        return new GenericPatternGroup(querySpecifications);
    }

    public static IQueryGroup of(IQuerySpecification<?> ... querySpecifications) {
        return GenericPatternGroup.of(new HashSet(Arrays.asList(querySpecifications)));
    }

    public static IQueryGroup of(IQueryGroup ... subGroups) {
        HashSet patterns = new HashSet();
        IQueryGroup[] iQueryGroupArray = subGroups;
        int n = subGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IQueryGroup group = iQueryGroupArray[n2];
            patterns.addAll(group.getSpecifications());
            ++n2;
        }
        return new GenericPatternGroup(patterns);
    }
}

