/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.tooling.ui.handlers;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.incquery.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.tooling.ui.queryexplorer.adapters.EMFModelConnector;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.PatternMatcherContent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.PatternMatcherRootContent;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.incquery.viewers.tooling.ui.views.ViewersToolingViewsUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class InitializeViewersHandler
extends AbstractHandler {
    IModelConnectorTypeEnum type;

    public InitializeViewersHandler(IModelConnectorTypeEnum modelconnectortype) {
        this.type = modelconnectortype;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection instanceof TreeSelection) {
            PatternMatcherRootContent root = this.getSelectedMatcherRoot(selection);
            try {
                IEditingDomainProvider providerEditor;
                ResourceSet resourceSet;
                IEditorPart editorPart = root.getEditorPart();
                if (editorPart instanceof IEditingDomainProvider && (resourceSet = (providerEditor = (IEditingDomainProvider)editorPart).getEditingDomain().getResourceSet()).getResources().size() > 0) {
                    ArrayList patterns = Lists.newArrayList();
                    Iterator iterator = root.getChildrenIterator();
                    while (iterator.hasNext()) {
                        patterns.add(((PatternMatcherContent)iterator.next()).getMatcher().getSpecification());
                    }
                    ViewerDataFilter filter = this.prepareFilterInformation(root);
                    EMFModelConnector emc = new EMFModelConnector(editorPart);
                    ViewersToolingViewsUtil.initializeContentsOnView(emc.getNotifier(this.type), patterns, filter);
                }
            }
            catch (IncQueryException e) {
                throw new ExecutionException("Error initializing pattern matcher.", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new ExecutionException("Invalid selrection", (Throwable)e);
            }
        }
        return null;
    }

    protected PatternMatcherRootContent getSelectedMatcherRoot(ISelection selection) {
        Object firstElement = ((TreeSelection)selection).getFirstElement();
        if (firstElement instanceof PatternMatcherRootContent) {
            return (PatternMatcherRootContent)firstElement;
        }
        if (firstElement instanceof PatternMatcherContent) {
            return (PatternMatcherRootContent)((PatternMatcherContent)firstElement).getParent();
        }
        throw new IllegalArgumentException("Selection should contain an Pattern match from the query explorer");
    }

    protected ViewerDataFilter prepareFilterInformation(PatternMatcherRootContent root) {
        ViewerDataFilter dataFilter = new ViewerDataFilter();
        Iterator iterator = root.getChildrenIterator();
        while (iterator.hasNext()) {
            PatternMatcherContent matcher = (PatternMatcherContent)iterator.next();
            Object[] filter = matcher.getFilter();
            if (!Iterables.any(Arrays.asList(filter), (Predicate)Predicates.notNull())) continue;
            IPatternMatch filterMatch = matcher.getMatcher().newMatch(filter);
            dataFilter.addSingleFilter(matcher.getMatcher().getSpecification(), filterMatch);
        }
        return dataFilter;
    }
}

