/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.recipes.helper;

import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.incquery.runtime.rete.recipes.BinaryInputRecipe;
import org.eclipse.incquery.runtime.rete.recipes.ExpressionDefinition;
import org.eclipse.incquery.runtime.rete.recipes.Mask;
import org.eclipse.incquery.runtime.rete.recipes.ProjectionIndexerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.RecipesFactory;
import org.eclipse.incquery.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.incquery.runtime.rete.recipes.TypeInputRecipe;
import org.eclipse.incquery.runtime.rete.recipes.UnaryInputRecipe;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class RecipesHelper {
    private static final RecipesFactory FACTORY = RecipesFactory.eINSTANCE;

    public static Mask mask(final int sourceArity, final Iterable<Integer> sourceIndices) {
        Mask _createMask = FACTORY.createMask();
        Procedures.Procedure1<Mask> _function = new Procedures.Procedure1<Mask>(){

            public void apply(Mask it) {
                it.setSourceArity(sourceArity);
                EList<Integer> _sourceIndices = it.getSourceIndices();
                Iterables.addAll(_sourceIndices, (Iterable)sourceIndices);
            }
        };
        return (Mask)ObjectExtensions.operator_doubleArrow((Object)_createMask, (Procedures.Procedure1)_function);
    }

    public static Mask mask(final int sourceArity, final int ... sourceIndices) {
        Mask _createMask = FACTORY.createMask();
        Procedures.Procedure1<Mask> _function = new Procedures.Procedure1<Mask>(){

            public void apply(Mask it) {
                it.setSourceArity(sourceArity);
                EList<Integer> _sourceIndices = it.getSourceIndices();
                Iterables.addAll(_sourceIndices, (Iterable)((Iterable)Conversions.doWrapArray((Object)sourceIndices)));
            }
        };
        return (Mask)ObjectExtensions.operator_doubleArrow((Object)_createMask, (Procedures.Procedure1)_function);
    }

    public static ProjectionIndexerRecipe projectionIndexerRecipe(final ReteNodeRecipe parent, final Mask mask) {
        ProjectionIndexerRecipe _createProjectionIndexerRecipe = FACTORY.createProjectionIndexerRecipe();
        Procedures.Procedure1<ProjectionIndexerRecipe> _function = new Procedures.Procedure1<ProjectionIndexerRecipe>(){

            public void apply(ProjectionIndexerRecipe it) {
                it.setParent(parent);
                it.setMask(mask);
            }
        };
        return (ProjectionIndexerRecipe)ObjectExtensions.operator_doubleArrow((Object)_createProjectionIndexerRecipe, (Procedures.Procedure1)_function);
    }

    public static ExpressionDefinition expressionDefinition(final Object evaluator) {
        ExpressionDefinition _createExpressionDefinition = FACTORY.createExpressionDefinition();
        Procedures.Procedure1<ExpressionDefinition> _function = new Procedures.Procedure1<ExpressionDefinition>(){

            public void apply(ExpressionDefinition it) {
                it.setEvaluator(evaluator);
            }
        };
        return (ExpressionDefinition)ObjectExtensions.operator_doubleArrow((Object)_createExpressionDefinition, (Procedures.Procedure1)_function);
    }

    public static TypeInputRecipe unaryInputRecipe(Object typeKey, String typeName) {
        UnaryInputRecipe _createUnaryInputRecipe = FACTORY.createUnaryInputRecipe();
        return RecipesHelper.fillOut(_createUnaryInputRecipe, typeKey, typeName);
    }

    public static TypeInputRecipe binaryInputRecipe(Object typeKey, String typeName) {
        BinaryInputRecipe _createBinaryInputRecipe = FACTORY.createBinaryInputRecipe();
        return RecipesHelper.fillOut(_createBinaryInputRecipe, typeKey, typeName);
    }

    private static TypeInputRecipe fillOut(TypeInputRecipe typeInputRecipe, final Object typeKey, final String typeName) {
        Procedures.Procedure1<TypeInputRecipe> _function = new Procedures.Procedure1<TypeInputRecipe>(){

            public void apply(TypeInputRecipe it) {
                it.setTypeKey(typeKey);
                it.setTypeName(typeName);
            }
        };
        return (TypeInputRecipe)ObjectExtensions.operator_doubleArrow((Object)typeInputRecipe, (Procedures.Procedure1)_function);
    }
}

