/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.rewriters;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PDisjunction;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.FlattenerCopier;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.PDisjunctionRewriter;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.RewriterException;

public class PQueryFlattener
extends PDisjunctionRewriter {
    private static final String FLATTENING_ERROR_MESSAGE = "Error occured while flattening";

    @Override
    public PDisjunction rewrite(PDisjunction disjunction) throws RewriterException {
        PQuery query = disjunction.getQuery();
        if (query.getAllReferredQueries().contains(query)) {
            throw new RewriterException("Recursive queries are not supported, can't flatten query named \"" + query.getFullyQualifiedName() + "\"", null, "Unsupported recursive query", query);
        }
        try {
            return this.flatten(query);
        }
        catch (Exception e) {
            throw new RewriterException(FLATTENING_ERROR_MESSAGE, null, FLATTENING_ERROR_MESSAGE, query, e);
        }
    }

    public PDisjunction flatten(PQuery pQuery) {
        return this.doFlatten(pQuery);
    }

    private PDisjunction doFlatten(PQuery pQuery) {
        Set<PBody> bodies = pQuery.getDisjunctBodies().getBodies();
        HashSet flattenedBodies = Sets.newHashSet();
        for (PBody pBody : bodies) {
            flattenedBodies.addAll(this.doFlatten(pBody));
        }
        return new PDisjunction(pQuery, flattenedBodies);
    }

    private Set<PBody> doFlatten(PBody pBody) {
        Set<PConstraint> constraints = pBody.getConstraints();
        if (!this.isFlatteningNeeded(constraints)) {
            return this.prepareFlatPBody(pBody);
        }
        ArrayList flattenedCalls = Lists.newArrayList();
        ArrayList flattenedDisjunctions = Lists.newArrayList();
        for (PConstraint pConstraint : constraints) {
            PositivePatternCall positivePatternCall;
            if (!(pConstraint instanceof PositivePatternCall) || !this.shouldFlatten(positivePatternCall = (PositivePatternCall)pConstraint)) continue;
            PQuery referredQuery = positivePatternCall.getReferredQuery();
            PDisjunction flattenedDisjunction = this.doFlatten(referredQuery);
            flattenedDisjunctions.add(flattenedDisjunction);
            flattenedCalls.add(positivePatternCall);
        }
        return this.createFlatPDisjunction(pBody, flattenedDisjunctions, flattenedCalls);
    }

    private Set<PBody> createFlatPDisjunction(PBody pBody, List<PDisjunction> flattenedDisjunctions, List<PositivePatternCall> flattenedCalls) {
        PQuery pQuery = pBody.getPattern();
        Set<List<PBody>> conjunctBodySets = this.combineBodies(flattenedDisjunctions);
        HashSet conjunctedBodies = Sets.newHashSet();
        for (List<PBody> bodySet : conjunctBodySets) {
            FlattenerCopier copier = new FlattenerCopier(pQuery, flattenedCalls, bodySet);
            for (PBody calledBody : bodySet) {
                this.copyBody(calledBody, copier, new HierarchicalName(), new ExportedParameterFilter());
            }
            this.copyBody(pBody, copier, new SameName());
            PBody copiedBody = copier.getCopiedBody();
            copiedBody.setStatus(PQuery.PQueryStatus.OK);
            conjunctedBodies.add(copiedBody);
        }
        return conjunctedBodies;
    }

    private Set<PBody> prepareFlatPBody(PBody pBody) {
        HashSet bodySet = Sets.newHashSet();
        FlattenerCopier flattenerCopier = this.copyBody(pBody);
        bodySet.add(flattenerCopier.getCopiedBody());
        return bodySet;
    }

    private boolean isFlatteningNeeded(Set<PConstraint> constraints) {
        for (PConstraint pConstraint : constraints) {
            if (!(pConstraint instanceof PositivePatternCall) || !this.shouldFlatten((PositivePatternCall)pConstraint)) continue;
            return true;
        }
        return false;
    }

    private Set<List<PBody>> combineBodies(List<PDisjunction> pDisjunctions) {
        ArrayList setsToCombine = Lists.newArrayList();
        Set result = Sets.newHashSet();
        if (pDisjunctions.size() != 0) {
            for (PDisjunction pDisjunction : pDisjunctions) {
                setsToCombine.add(pDisjunction.getBodies());
            }
            result = Sets.cartesianProduct((List)setsToCombine);
        }
        return result;
    }

    private FlattenerCopier copyBody(PBody pBody) {
        return this.copyBody(pBody, new SameName());
    }

    private FlattenerCopier copyBody(PBody pBody, INamingTool namingTool) {
        FlattenerCopier copier = new FlattenerCopier(pBody.getPattern(), Lists.newArrayList(), Lists.newArrayList());
        this.copyBody(pBody, copier, namingTool);
        return copier;
    }

    private void copyBody(PBody pBody, FlattenerCopier copier, INamingTool namingTool) {
        this.copyBody(pBody, copier, namingTool, new AllowAllFilter());
    }

    private void copyBody(PBody pBody, FlattenerCopier copier, INamingTool namingTool, IConstraintFilter filter) {
        Set<PVariable> allVariables = pBody.getAllVariables();
        for (PVariable pVariable : allVariables) {
            copier.copyVariable(pVariable, namingTool.createVariableName(pVariable, pBody.getPattern()));
        }
        Set<PConstraint> constraints = pBody.getConstraints();
        for (PConstraint pConstraint : constraints) {
            if (filter.filter(pConstraint)) continue;
            copier.copyConstraint(pConstraint);
        }
    }

    private String getPQueryName(PQuery query) {
        String fullyQualifiedName = query.getFullyQualifiedName();
        int beginIndex = fullyQualifiedName.lastIndexOf(".") + 1;
        return fullyQualifiedName.substring(beginIndex);
    }

    private boolean shouldFlatten(PositivePatternCall positivePatternCall) {
        boolean shouldFlatten = true;
        return shouldFlatten;
    }

    private class AllowAllFilter
    implements IConstraintFilter {
        private AllowAllFilter() {
        }

        @Override
        public boolean filter(PConstraint constraint) {
            return false;
        }
    }

    private class ExportedParameterFilter
    implements IConstraintFilter {
        private ExportedParameterFilter() {
        }

        @Override
        public boolean filter(PConstraint constraint) {
            return constraint instanceof ExportedParameter;
        }
    }

    private class HierarchicalName
    implements INamingTool {
        private HierarchicalName() {
        }

        @Override
        public String createVariableName(PVariable pVariable, PQuery query) {
            return String.valueOf(PQueryFlattener.this.getPQueryName(query)) + "_" + pVariable.getName();
        }
    }

    private static interface IConstraintFilter {
        public boolean filter(PConstraint var1);
    }

    private static interface INamingTool {
        public String createVariableName(PVariable var1, PQuery var2);
    }

    private class SameName
    implements INamingTool {
        private SameName() {
        }

        @Override
        public String createVariableName(PVariable pVariable, PQuery query) {
            return pVariable.getName();
        }
    }
}

