/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.ui.labeling;

import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.incquery.patternlanguage.emf.EMFPatternLanguageScopeHelper;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.ClassType;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EClassifierConstraint;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EnumValue;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PackageImport;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.ReferenceType;
import org.eclipse.incquery.patternlanguage.patternLanguage.AggregatedValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.AggregatorExpression;
import org.eclipse.incquery.patternlanguage.patternLanguage.BoolValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.CheckConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.CompareConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.CompareFeature;
import org.eclipse.incquery.patternlanguage.patternLanguage.CountAggregator;
import org.eclipse.incquery.patternlanguage.patternLanguage.DoubleValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.FunctionEvaluationValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.IntValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.ListValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.PathExpressionConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.PathExpressionHead;
import org.eclipse.incquery.patternlanguage.patternLanguage.PathExpressionTail;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternCall;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternCompositionConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.StringValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableValue;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.ui.labeling.XbaseLabelProvider;

public class EMFPatternLanguageLabelProvider
extends XbaseLabelProvider {
    @Inject
    public EMFPatternLanguageLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    String text(PatternModel model) {
        return "Pattern Model";
    }

    String text(PackageImport ele) {
        String name = ele.getEPackage() != null ? ele.getEPackage().getName() : "\u00abpackage\u00bb";
        return String.format("import %s", name);
    }

    String text(Pattern pattern) {
        return String.format("pattern %s/%d", pattern.getName(), pattern.getParameters().size());
    }

    String text(PatternBody ele) {
        return String.format("body #%d", ((Pattern)ele.eContainer()).getBodies().indexOf((Object)ele) + 1);
    }

    String text(EClassifierConstraint constraint) {
        String typename = ((ClassType)constraint.getType()).getClassname().getName();
        return String.format("%s (%s)", typename, constraint.getVar().getVar());
    }

    String text(CompareConstraint constraint) {
        CompareFeature feature = constraint.getFeature();
        String op = feature.equals((Object)CompareFeature.EQUALITY) ? "==" : (feature.equals((Object)CompareFeature.INEQUALITY) ? "!=" : "<???>");
        String left = this.getValueText(constraint.getLeftOperand());
        String right = this.getValueText(constraint.getRightOperand());
        return String.format("%s %s %s", left, op, right);
    }

    String text(PatternCompositionConstraint constraint) {
        String modifiers = constraint.isNegative() ? "neg " : "";
        return String.format("%s%s", modifiers, this.text(constraint.getCall()));
    }

    String text(PatternCall call) {
        String transitiveOp = call.isTransitive() ? "+" : "";
        String name = call.getPatternRef() == null ? "<null>" : call.getPatternRef().getName();
        return String.format("find %s/%d%s", name, call.getParameters().size(), transitiveOp);
    }

    String text(PathExpressionConstraint constraint) {
        String typename = ((ClassType)constraint.getHead().getType()).getClassname().getName();
        String varName = constraint.getHead().getSrc() != null ? constraint.getHead().getSrc().getVar() : "\u00abtype\u00bb";
        return String.format("%s (%s)", typename, varName);
    }

    String text(CheckConstraint constraint) {
        return String.format("check()", new Object[0]);
    }

    String text(FunctionEvaluationValue eval) {
        return String.format("eval()", new Object[0]);
    }

    String text(AggregatedValue aggregate) {
        String aggregator = this.getAggregatorText(aggregate.getAggregator());
        String call = this.text(aggregate.getCall());
        return String.format("%s %s", aggregator, call);
    }

    String text(PathExpressionTail tail) {
        EStructuralFeature refname = ((ReferenceType)tail.getType()).getRefname();
        String type = refname != null ? refname.getName() : "\u00abtype\u00bb";
        String varName = "";
        if (tail.getTail() == null) {
            PathExpressionHead head = EMFPatternLanguageScopeHelper.getExpressionHead((PathExpressionTail)tail);
            varName = String.format("(%s)", this.getValueText(head.getDst()));
        }
        return String.format("%s %s", type, varName);
    }

    private String getAggregatorText(AggregatorExpression aggregator) {
        if (aggregator instanceof CountAggregator) {
            return String.format("count", new Object[0]);
        }
        return aggregator.toString();
    }

    String getValueText(ValueReference ref) {
        if (ref instanceof VariableValue) {
            return ((VariableValue)ref).getValue().getVar();
        }
        if (ref instanceof IntValue) {
            return Integer.toString(((IntValue)ref).getValue());
        }
        if (ref instanceof BoolValue) {
            return Boolean.toString(((BoolValue)ref).isValue());
        }
        if (ref instanceof DoubleValue) {
            return Double.toString(((DoubleValue)ref).getValue());
        }
        if (ref instanceof ListValue) {
            EList values = ((ListValue)ref).getValues();
            ArrayList<String> valueStrings = new ArrayList<String>();
            for (ValueReference valueReference : values) {
                valueStrings.add(this.getValueText(valueReference));
            }
            return "{" + Strings.concat((String)", ", valueStrings) + "}";
        }
        if (ref instanceof StringValue) {
            return "\"" + ((StringValue)ref).getValue() + "\"";
        }
        if (ref instanceof EnumValue) {
            EnumValue enumVal = (EnumValue)ref;
            if (enumVal.getLiteral() == null || enumVal.getLiteral().getLiteral() == null) {
                return "";
            }
            String enumName = enumVal.getEnumeration() != null ? enumVal.getEnumeration().getName() : enumVal.getLiteral().getEEnum().getName();
            return String.valueOf(enumName) + "::" + enumVal.getLiteral().getLiteral();
        }
        if (ref instanceof AggregatedValue) {
            return this.text((AggregatedValue)ref);
        }
        if (ref instanceof FunctionEvaluationValue) {
            return this.text((FunctionEvaluationValue)ref);
        }
        return null;
    }
}

