/**
 * Copyright (c) 2010-2012, Tamas Szabo, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Tamas Szabo (itemis AG) - initial API and implementation
 */
package org.eclipse.incquery.xcore.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xcore.XClass;
import org.eclipse.emf.ecore.xcore.XClassifier;
import org.eclipse.emf.ecore.xcore.XDataType;
import org.eclipse.emf.ecore.xcore.XOperation;
import org.eclipse.emf.ecore.xcore.XPackage;
import org.eclipse.emf.ecore.xcore.XStructuralFeature;
import org.eclipse.emf.ecore.xcore.generator.XcoreAppendable;
import org.eclipse.emf.ecore.xcore.generator.XcoreGenerator;
import org.eclipse.emf.ecore.xcore.mappings.XClassMapping;
import org.eclipse.emf.ecore.xcore.mappings.XDataTypeMapping;
import org.eclipse.emf.ecore.xcore.mappings.XFeatureMapping;
import org.eclipse.emf.ecore.xcore.mappings.XOperationMapping;
import org.eclipse.emf.ecore.xcore.mappings.XPackageMapping;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternModel;
import org.eclipse.incquery.tooling.core.generator.ExtensionGenerator;
import org.eclipse.incquery.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.incquery.xcore.XIncQueryDerivedFeature;
import org.eclipse.incquery.xcore.generator.WellBehavingFeatureDefinitionGenerator;
import org.eclipse.incquery.xcore.mappings.IncQueryXcoreMapper;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@SuppressWarnings("all")
public class IncQueryXcoreGenerator extends XcoreGenerator {
  @Inject
  private XbaseCompiler compiler;
  
  @Inject
  @Extension
  private IncQueryXcoreMapper mappings;
  
  public static String queryBasedFeatureFactory = "org.eclipse.incquery.querybasedfeature";
  
  public void doGenerate(final Resource resource, final IFileSystemAccess fsa) {
    try {
      EList<EObject> _contents = resource.getContents();
      EObject _head = IterableExtensions.<EObject>head(_contents);
      final XPackage pack = ((XPackage) _head);
      XPackageMapping _mapping = this.mappings.getMapping(pack);
      final EPackage ePackage = _mapping.getEPackage();
      final List<IPluginExtension> extensions = Lists.<IPluginExtension>newArrayList();
      EList<EObject> _contents_1 = resource.getContents();
      Iterable<GenModel> _filter = Iterables.<GenModel>filter(_contents_1, GenModel.class);
      final GenModel genModel = IterableExtensions.<GenModel>head(_filter);
      IWorkspace _workspace = ResourcesPlugin.getWorkspace();
      IWorkspaceRoot _root = _workspace.getRoot();
      String _modelPluginID = genModel.getModelPluginID();
      final IProject project = _root.getProject(_modelPluginID);
      ExtensionGenerator _extensionGenerator = new ExtensionGenerator();
      final ExtensionGenerator exGen = _extensionGenerator;
      exGen.setProject(project);
      EcoreUtil.setAnnotation(ePackage, 
        EcorePackage.eNS_URI, 
        "settingDelegates", 
        IncQueryXcoreGenerator.queryBasedFeatureFactory);
      final HashSet<ETypedElement> processed = CollectionLiterals.<ETypedElement>newHashSet();
      EList<XClassifier> _classifiers = pack.getClassifiers();
      for (final XClassifier xClassifier : _classifiers) {
        if ((xClassifier instanceof XDataType)) {
          final XDataType xDataType = ((XDataType) xClassifier);
          XDataTypeMapping _mapping_1 = this.mappings.getMapping(xDataType);
          final EDataType eDataType = _mapping_1.getEDataType();
          final XBlockExpression createBody = xDataType.getCreateBody();
          XDataTypeMapping _mapping_2 = this.mappings.getMapping(xDataType);
          final JvmOperation creator = _mapping_2.getCreator();
          boolean _and = false;
          boolean _notEquals = (!Objects.equal(createBody, null));
          if (!_notEquals) {
            _and = false;
          } else {
            boolean _notEquals_1 = (!Objects.equal(creator, null));
            _and = (_notEquals && _notEquals_1);
          }
          if (_and) {
            final XcoreAppendable appendable = this.createAppendable();
            EList<JvmFormalParameter> _parameters = creator.getParameters();
            JvmFormalParameter _get = _parameters.get(0);
            appendable.declareVariable(_get, "it");
            JvmTypeReference _returnType = creator.getReturnType();
            Set<JvmTypeReference> _emptySet = Collections.<JvmTypeReference>emptySet();
            this.compiler.compile(createBody, appendable, _returnType, _emptySet);
            String _string = appendable.toString();
            String _extractBody = this.extractBody(_string);
            EcoreUtil.setAnnotation(eDataType, GenModelPackage.eNS_URI, "create", _extractBody);
          }
          final XBlockExpression convertBody = xDataType.getConvertBody();
          XDataTypeMapping _mapping_3 = this.mappings.getMapping(xDataType);
          final JvmOperation converter = _mapping_3.getConverter();
          boolean _and_1 = false;
          boolean _notEquals_2 = (!Objects.equal(convertBody, null));
          if (!_notEquals_2) {
            _and_1 = false;
          } else {
            boolean _notEquals_3 = (!Objects.equal(converter, null));
            _and_1 = (_notEquals_2 && _notEquals_3);
          }
          if (_and_1) {
            final XcoreAppendable appendable_1 = this.createAppendable();
            EList<JvmFormalParameter> _parameters_1 = converter.getParameters();
            JvmFormalParameter _get_1 = _parameters_1.get(0);
            appendable_1.declareVariable(_get_1, "it");
            JvmTypeReference _returnType_1 = converter.getReturnType();
            Set<JvmTypeReference> _emptySet_1 = Collections.<JvmTypeReference>emptySet();
            this.compiler.compile(convertBody, appendable_1, _returnType_1, _emptySet_1);
            String _string_1 = appendable_1.toString();
            String _extractBody_1 = this.extractBody(_string_1);
            EcoreUtil.setAnnotation(eDataType, GenModelPackage.eNS_URI, "convert", _extractBody_1);
          }
        } else {
          final XClass xClass = ((XClass) xClassifier);
          XClassMapping _mapping_4 = this.mappings.getMapping(xClass);
          final EClass eClass = _mapping_4.getEClass();
          EList<EStructuralFeature> _eAllStructuralFeatures = eClass.getEAllStructuralFeatures();
          for (final EStructuralFeature eStructuralFeature : _eAllStructuralFeatures) {
            boolean _add = processed.add(eStructuralFeature);
            if (_add) {
              final EObject xFeature = this.mappings.getXcoreElement(eStructuralFeature);
              boolean _notEquals_4 = (!Objects.equal(xFeature, null));
              if (_notEquals_4) {
                if ((xFeature instanceof XStructuralFeature)) {
                  final XBlockExpression getBody = ((XStructuralFeature) xFeature).getGetBody();
                  boolean _notEquals_5 = (!Objects.equal(getBody, null));
                  if (_notEquals_5) {
                    XFeatureMapping _mapping_5 = this.mappings.getMapping(((XStructuralFeature) xFeature));
                    final JvmOperation getter = _mapping_5.getGetter();
                    final XcoreAppendable appendable_2 = this.createAppendable();
                    JvmTypeReference _returnType_2 = getter.getReturnType();
                    Set<JvmTypeReference> _emptySet_2 = Collections.<JvmTypeReference>emptySet();
                    this.compiler.compile(getBody, appendable_2, _returnType_2, _emptySet_2);
                    String _string_2 = appendable_2.toString();
                    String _extractBody_2 = this.extractBody(_string_2);
                    EcoreUtil.setAnnotation(eStructuralFeature, GenModelPackage.eNS_URI, "get", _extractBody_2);
                  }
                } else {
                  if ((xFeature instanceof XIncQueryDerivedFeature)) {
                    final XIncQueryDerivedFeature feature = ((XIncQueryDerivedFeature) xFeature);
                    Pattern _pattern = feature.getPattern();
                    EObject _eContainer = _pattern.eContainer();
                    String _packageName = ((PatternModel) _eContainer).getPackageName();
                    String _plus = (_packageName + ".");
                    Pattern _pattern_1 = feature.getPattern();
                    String _name = _pattern_1.getName();
                    String _plus_1 = (_plus + _name);
                    EcoreUtil.setAnnotation(eStructuralFeature, IncQueryXcoreGenerator.queryBasedFeatureFactory, 
                      "patternFQN", _plus_1);
                    IPluginExtension _generateExtension = WellBehavingFeatureDefinitionGenerator.generateExtension(eStructuralFeature, exGen);
                    extensions.add(_generateExtension);
                  }
                }
              }
            }
          }
          EList<EOperation> _eAllOperations = eClass.getEAllOperations();
          for (final EOperation eOperation : _eAllOperations) {
            boolean _add_1 = processed.add(eOperation);
            if (_add_1) {
              final XOperation xOperation = this.mappings.getXOperation(eOperation);
              boolean _notEquals_6 = (!Objects.equal(xOperation, null));
              if (_notEquals_6) {
                final XBlockExpression body = xOperation.getBody();
                boolean _notEquals_7 = (!Objects.equal(body, null));
                if (_notEquals_7) {
                  XOperationMapping _mapping_6 = this.mappings.getMapping(xOperation);
                  final JvmOperation jvmOperation = _mapping_6.getJvmOperation();
                  boolean _notEquals_8 = (!Objects.equal(jvmOperation, null));
                  if (_notEquals_8) {
                    final XcoreAppendable appendable_3 = this.createAppendable();
                    EList<JvmFormalParameter> _parameters_2 = jvmOperation.getParameters();
                    for (final JvmFormalParameter parameter : _parameters_2) {
                      String _name_1 = parameter.getName();
                      appendable_3.declareVariable(parameter, _name_1);
                    }
                    JvmTypeReference _returnType_3 = jvmOperation.getReturnType();
                    EList<JvmTypeReference> _exceptions = jvmOperation.getExceptions();
                    HashSet<JvmTypeReference> _hashSet = new HashSet<JvmTypeReference>(_exceptions);
                    this.compiler.compile(body, appendable_3, _returnType_3, _hashSet);
                    String _string_3 = appendable_3.toString();
                    String _extractBody_3 = this.extractBody(_string_3);
                    EcoreUtil.setAnnotation(eOperation, GenModelPackage.eNS_URI, "body", _extractBody_3);
                  }
                }
              }
            }
          }
        }
      }
      URI _uRI = resource.getURI();
      String _modelDirectory = this.getModelDirectory(_uRI);
      genModel.setModelDirectory(_modelDirectory);
      this.generateGenModel(genModel, fsa);
      ArrayList<Pair<String,String>> _removableExtensionIdentifiers = WellBehavingFeatureDefinitionGenerator.getRemovableExtensionIdentifiers();
      ProjectGenerationHelper.ensureExtensions(project, extensions, _removableExtensionIdentifiers);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public String getModelDirectory(final URI uri) {
    boolean _and = false;
    if (!EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
      _and = false;
    } else {
      int _segmentCount = uri.segmentCount();
      boolean _greaterEqualsThan = (_segmentCount >= 2);
      _and = (EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE && _greaterEqualsThan);
    }
    if (_and) {
      try {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = workspace.getRoot();
        String _segment = uri.segment(1);
        final IProject project = _root.getProject(_segment);
        final IJavaProject javaProject = JavaCore.create(project);
        final IClasspathEntry[] classpath = javaProject.getRawClasspath();
        IClasspathEntry bestEntry = null;
        for (final IClasspathEntry classpathEntry : classpath) {
          int _entryKind = classpathEntry.getEntryKind();
          boolean _equals = (_entryKind == IClasspathEntry.CPE_SOURCE);
          if (_equals) {
            boolean _equals_1 = Objects.equal(bestEntry, null);
            if (_equals_1) {
              bestEntry = classpathEntry;
            } else {
              boolean _or = false;
              IPath _path = classpathEntry.getPath();
              String _string = _path.toString();
              boolean _endsWith = _string.endsWith("src-gen");
              if (_endsWith) {
                _or = true;
              } else {
                IPath _path_1 = classpathEntry.getPath();
                String _string_1 = _path_1.toString();
                boolean _endsWith_1 = _string_1.endsWith("src-gen/");
                _or = (_endsWith || _endsWith_1);
              }
              if (_or) {
                bestEntry = classpathEntry;
              }
            }
          }
        }
        String _xifexpression = null;
        boolean _equals_2 = Objects.equal(bestEntry, null);
        if (_equals_2) {
          IPath _fullPath = project.getFullPath();
          String _plus = (_fullPath + "/src");
          _xifexpression = _plus;
        } else {
          IPath _path_2 = bestEntry.getPath();
          String _string_2 = _path_2.toString();
          _xifexpression = _string_2;
        }
        return _xifexpression;
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception exception = (Exception)_t;
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
    return null;
  }
}
