/**
 * Copyright (c) 2010-2012, Mark Czotter, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Mark Czotter - initial API and implementation
 */
package org.eclipse.incquery.tooling.core.generator.jvmmodel;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.tooling.core.generator.jvmmodel.JavadocInferrer;
import org.eclipse.incquery.tooling.core.generator.util.EMFJvmTypesBuilder;
import org.eclipse.incquery.tooling.core.generator.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * {@link IPatternMatch} implementation inferer.
 * 
 * @author Mark Czotter
 */
@SuppressWarnings("all")
public class PatternMatchClassInferrer {
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  @Extension
  private IQualifiedNameProvider _iQualifiedNameProvider;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  @Inject
  private TypeReferences typeReference;
  
  @Inject
  @Extension
  private IJvmModelAssociator associator;
  
  /**
   * Infers fields for Match class based on the input 'pattern'.
   */
  public boolean inferMatchClassFields(final JvmDeclaredType matchClass, final Pattern pattern) {
    boolean _xblockexpression = false;
    {
      EList<Variable> _parameters = pattern.getParameters();
      for (final Variable variable : _parameters) {
        EList<JvmMember> _members = matchClass.getMembers();
        String _fieldName = this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
        JvmTypeReference _calculateType = this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
        JvmField _field = this._eMFJvmTypesBuilder.toField(variable, _fieldName, _calculateType);
        this._eMFJvmTypesBuilder.<JvmField>operator_add(_members, _field);
      }
      EList<JvmMember> _members_1 = matchClass.getMembers();
      JvmTypeReference _newRawTypeRef = this._eMFJvmTypesBuilder.newRawTypeRef(pattern, String.class);
      JvmTypeReference _newTypeRef = this._eMFJvmTypesBuilder.newTypeRef(pattern, List.class, _newRawTypeRef);
      final Procedure1<JvmField> _function = new Procedure1<JvmField>() {
        public void apply(final JvmField it) {
          it.setStatic(true);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("makeImmutableList(");
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _hasElements = false;
                for(final Variable variable : _parameters) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(", ", "");
                  }
                  _builder.append("\"");
                  String _name = variable.getName();
                  _builder.append(_name, "");
                  _builder.append("\"");
                }
              }
              _builder.append(")");
              it.append(_builder);
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setInitializer(it, _function);
        }
      };
      JvmField _field_1 = this._eMFJvmTypesBuilder.toField(pattern, "parameterNames", _newTypeRef, _function);
      boolean _add = this._eMFJvmTypesBuilder.<JvmField>operator_add(_members_1, _field_1);
      _xblockexpression = (_add);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers constructors for Match class based on the input 'pattern'.
   */
  public boolean inferMatchClassConstructors(final JvmDeclaredType matchClass, final Pattern pattern) {
    EList<JvmMember> _members = matchClass.getMembers();
    final Procedure1<JvmConstructor> _function = new Procedure1<JvmConstructor>() {
      public void apply(final JvmConstructor it) {
        String _matchClassName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
        it.setSimpleName(_matchClassName);
        it.setVisibility(JvmVisibility.PRIVATE);
        EList<Variable> _parameters = pattern.getParameters();
        for (final Variable variable : _parameters) {
          {
            final JvmTypeReference javaType = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
            EList<JvmFormalParameter> _parameters_1 = it.getParameters();
            String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable);
            JvmFormalParameter _parameter = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toParameter(variable, _parameterName, javaType);
            PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
          }
        }
        final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
          public void apply(final ITreeAppendable it) {
            StringConcatenation _builder = new StringConcatenation();
            {
              EList<Variable> _parameters = pattern.getParameters();
              for(final Variable variable : _parameters) {
                _builder.append("this.");
                String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                _builder.append(_fieldName, "");
                _builder.append(" = ");
                String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable);
                _builder.append(_parameterName, "");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              }
            }
            it.append(_builder);
          }
        };
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
      }
    };
    JvmConstructor _constructor = this._eMFJvmTypesBuilder.toConstructor(pattern, _function);
    boolean _add = this._eMFJvmTypesBuilder.<JvmConstructor>operator_add(_members, _constructor);
    return _add;
  }
  
  /**
   * Infers getters for Match class based on the input 'pattern'.
   */
  public void inferMatchClassGetters(final JvmDeclaredType matchClass, final Pattern pattern) {
    EList<JvmMember> _members = matchClass.getMembers();
    JvmTypeReference _newTypeRef = this._eMFJvmTypesBuilder.newTypeRef(pattern, Object.class);
    final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
      public void apply(final JvmOperation it) {
        EList<JvmAnnotationReference> _annotations = it.getAnnotations();
        JvmAnnotationReference _annotation = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Override.class);
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
        EList<JvmFormalParameter> _parameters = it.getParameters();
        JvmTypeReference _newTypeRef = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, String.class);
        JvmFormalParameter _parameter = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "parameterName", _newTypeRef);
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
        final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
          public void apply(final ITreeAppendable it) {
            StringConcatenation _builder = new StringConcatenation();
            {
              EList<Variable> _parameters = pattern.getParameters();
              for(final Variable variable : _parameters) {
                _builder.append("if (\"");
                String _name = variable.getName();
                _builder.append(_name, "");
                _builder.append("\".equals(parameterName)) return this.");
                String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                _builder.append(_fieldName, "");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
              }
            }
            _builder.append("return null;");
            _builder.newLine();
            it.append(_builder);
          }
        };
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
      }
    };
    JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "get", _newTypeRef, _function);
    this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
    EList<Variable> _parameters = pattern.getParameters();
    for (final Variable variable : _parameters) {
      {
        String _terMethodName = this._eMFPatternLanguageJvmModelInferrerUtil.getterMethodName(variable);
        JvmTypeReference _calculateType = this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
        final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return this.");
                String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                _builder.append(_fieldName, "");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                it.append(_builder);
              }
            };
            PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
        final JvmOperation getter = this._eMFJvmTypesBuilder.toMethod(variable, _terMethodName, _calculateType, _function_1);
        EList<JvmMember> _members_1 = matchClass.getMembers();
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, getter);
        this.associator.associatePrimary(variable, getter);
      }
    }
  }
  
  /**
   * Infers setters for Match class based on the input 'pattern'.
   */
  public void inferMatchClassSetters(final JvmDeclaredType matchClass, final Pattern pattern) {
    EList<JvmMember> _members = matchClass.getMembers();
    JvmTypeReference _newTypeRef = this._eMFJvmTypesBuilder.newTypeRef(pattern, boolean.class);
    final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
      public void apply(final JvmOperation it) {
        JvmTypeReference _newTypeRef = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, Boolean.TYPE);
        it.setReturnType(_newTypeRef);
        EList<JvmAnnotationReference> _annotations = it.getAnnotations();
        JvmAnnotationReference _annotation = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Override.class);
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
        EList<JvmFormalParameter> _parameters = it.getParameters();
        JvmTypeReference _newTypeRef_1 = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, String.class);
        JvmFormalParameter _parameter = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "parameterName", _newTypeRef_1);
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
        EList<JvmFormalParameter> _parameters_1 = it.getParameters();
        JvmTypeReference _newTypeRef_2 = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, Object.class);
        JvmFormalParameter _parameter_1 = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "newValue", _newTypeRef_2);
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter_1);
        final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
          public void apply(final ITreeAppendable it) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("if (!isMutable()) throw new java.lang.UnsupportedOperationException();");
            _builder.newLine();
            {
              EList<Variable> _parameters = pattern.getParameters();
              for(final Variable variable : _parameters) {
                final JvmTypeReference type = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
                _builder.newLineIfNotEmpty();
                final String typeName = type.getQualifiedName();
                _builder.newLineIfNotEmpty();
                _builder.append("if (\"");
                String _name = variable.getName();
                _builder.append(_name, "");
                _builder.append("\".equals(parameterName) ");
                {
                  boolean _is = PatternMatchClassInferrer.this.typeReference.is(type, Object.class);
                  if (_is) {
                    _builder.append("&& newValue instanceof ");
                    _builder.append(typeName, "");
                  }
                }
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("this.");
                String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                _builder.append(_fieldName, "	");
                _builder.append(" = (");
                _builder.append(typeName, "	");
                _builder.append(") newValue;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("return true;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
              }
            }
            _builder.append("return false;");
            _builder.newLine();
            it.append(_builder);
          }
        };
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
      }
    };
    JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "set", _newTypeRef, _function);
    this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
    EList<Variable> _parameters = pattern.getParameters();
    for (final Variable variable : _parameters) {
      EList<JvmMember> _members_1 = matchClass.getMembers();
      String _setterMethodName = this._eMFPatternLanguageJvmModelInferrerUtil.setterMethodName(variable);
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          JvmTypeReference _newTypeRef = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, Void.TYPE);
          it.setReturnType(_newTypeRef);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable);
          JvmTypeReference _calculateType = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
          JvmFormalParameter _parameter = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, _parameterName, _calculateType);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("if (!isMutable()) throw new java.lang.UnsupportedOperationException();");
              _builder.newLine();
              _builder.append("this.");
              String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
              _builder.append(_fieldName, "");
              _builder.append(" = ");
              String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable);
              _builder.append(_parameterName, "");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
              it.append(_builder);
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(variable, _setterMethodName, null, _function_1);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
    }
  }
  
  /**
   * Infers methods for Match class based on the input 'pattern'.
   */
  public boolean inferMatchClassMethods(final JvmDeclaredType matchClass, final Pattern pattern) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = matchClass.getMembers();
      JvmTypeReference _newTypeRef = this._eMFJvmTypesBuilder.newTypeRef(pattern, String.class);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotation = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Override.class);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("return \"");
              QualifiedName _fullyQualifiedName = PatternMatchClassInferrer.this._iQualifiedNameProvider.getFullyQualifiedName(pattern);
              _builder.append(_fullyQualifiedName, "");
              _builder.append("\";");
              _builder.newLineIfNotEmpty();
              it.append(_builder);
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "patternName", _newTypeRef, _function);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
      EList<JvmMember> _members_1 = matchClass.getMembers();
      JvmTypeReference _newRawTypeRef = this._eMFJvmTypesBuilder.newRawTypeRef(pattern, String.class);
      JvmTypeReference _newTypeRef_1 = this._eMFJvmTypesBuilder.newTypeRef(pattern, List.class, _newRawTypeRef);
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotation = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Override.class);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("return ");
              String _matchClassName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
              _builder.append(_matchClassName, "");
              _builder.append(".parameterNames;");
              _builder.newLineIfNotEmpty();
              it.append(_builder);
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(pattern, "parameterNames", _newTypeRef_1, _function_1);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
      EList<JvmMember> _members_2 = matchClass.getMembers();
      JvmTypeReference _newTypeRef_2 = this._eMFJvmTypesBuilder.newTypeRef(pattern, Object.class);
      JvmTypeReference _addArrayTypeDimension = this._eMFJvmTypesBuilder.addArrayTypeDimension(_newTypeRef_2);
      final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotation = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Override.class);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("return new Object[]{");
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _hasElements = false;
                for(final Variable variable : _parameters) {
                  if (!_hasElements) {
                    _hasElements = true;
                  } else {
                    _builder.appendImmediate(", ", "");
                  }
                  String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                  _builder.append(_fieldName, "");
                }
              }
              _builder.append("};");
              _builder.newLineIfNotEmpty();
              it.append(_builder);
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      JvmOperation _method_2 = this._eMFJvmTypesBuilder.toMethod(pattern, "toArray", _addArrayTypeDimension, _function_2);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method_2);
      EList<JvmMember> _members_3 = matchClass.getMembers();
      JvmTypeReference _newTypeRef_3 = this._eMFJvmTypesBuilder.newTypeRef(pattern, String.class);
      final Procedure1<JvmOperation> _function_3 = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotation = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Override.class);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              EList<Variable> _parameters = pattern.getParameters();
              boolean _isEmpty = _parameters.isEmpty();
              if (_isEmpty) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return \"[]\";");
                it.append(_builder);
              } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("StringBuilder result = new StringBuilder();");
                _builder_1.newLine();
                {
                  EList<Variable> _parameters_1 = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable variable : _parameters_1) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder_1.appendImmediate(" + \", \");\n", "");
                    }
                    _builder_1.append("result.append(\"\\\"");
                    String _name = variable.getName();
                    _builder_1.append(_name, "");
                    _builder_1.append("\\\"=\" + prettyPrintValue(");
                    String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                    _builder_1.append(_fieldName, "");
                    _builder_1.append(")");
                  }
                  if (_hasElements) {
                    _builder_1.append(");\n", "");
                  }
                }
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("return result.toString();");
                _builder_1.newLine();
                it.append(_builder_1);
              }
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      JvmOperation _method_3 = this._eMFJvmTypesBuilder.toMethod(pattern, "prettyPrint", _newTypeRef_3, _function_3);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_3, _method_3);
      EList<JvmMember> _members_4 = matchClass.getMembers();
      JvmTypeReference _newTypeRef_4 = this._eMFJvmTypesBuilder.newTypeRef(pattern, int.class);
      final Procedure1<JvmOperation> _function_4 = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotation = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Override.class);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("final int prime = 31;");
              _builder.newLine();
              _builder.append("int result = 1;");
              _builder.newLine();
              {
                EList<Variable> _parameters = pattern.getParameters();
                for(final Variable variable : _parameters) {
                  _builder.append("result = prime * result + ((");
                  String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                  _builder.append(_fieldName, "");
                  _builder.append(" == null) ? 0 : ");
                  String _fieldName_1 = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                  _builder.append(_fieldName_1, "");
                  _builder.append(".hashCode()); ");
                  _builder.newLineIfNotEmpty();
                }
              }
              _builder.append("return result; ");
              _builder.newLine();
              it.append(_builder);
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      JvmOperation _method_4 = this._eMFJvmTypesBuilder.toMethod(pattern, "hashCode", _newTypeRef_4, _function_4);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_4, _method_4);
      EList<JvmMember> _members_5 = matchClass.getMembers();
      JvmTypeReference _newTypeRef_5 = this._eMFJvmTypesBuilder.newTypeRef(pattern, boolean.class);
      final Procedure1<JvmOperation> _function_5 = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotation = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Override.class);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _newTypeRef = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, Object.class);
          JvmFormalParameter _parameter = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "obj", _newTypeRef);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("if (this == obj)");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("return true;");
              _builder.newLine();
              _builder.append("if (!(obj instanceof ");
              String _matchClassName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
              _builder.append(_matchClassName, "");
              _builder.append(")) { // this should be infrequent\t\t\t\t");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("if (obj == null)");
              _builder.newLine();
              _builder.append("\t\t");
              _builder.append("return false;");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("if (!(obj instanceof ");
              it.append(_builder);
              PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(it, pattern, IPatternMatch.class);
              StringConcatenation _builder_1 = new StringConcatenation();
              _builder_1.append("))");
              _builder_1.newLine();
              _builder_1.append("\t\t");
              _builder_1.append("return false;");
              _builder_1.newLine();
              it.append(_builder_1);
              it.append("\t");
              PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(it, pattern, IPatternMatch.class);
              it.append(" ");
              StringConcatenation _builder_2 = new StringConcatenation();
              _builder_2.append("otherSig  = (");
              it.append(_builder_2);
              PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(it, pattern, IPatternMatch.class);
              StringConcatenation _builder_3 = new StringConcatenation();
              _builder_3.append(") obj;");
              _builder_3.newLine();
              _builder_3.append("\t");
              _builder_3.append("if (!pattern().equals(otherSig.pattern()))");
              _builder_3.newLine();
              _builder_3.append("\t\t");
              _builder_3.append("return false;");
              _builder_3.newLine();
              _builder_3.append("\t");
              _builder_3.append("return ");
              it.append(_builder_3);
              PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(it, pattern, Arrays.class);
              StringConcatenation _builder_4 = new StringConcatenation();
              _builder_4.append(".deepEquals(toArray(), otherSig.toArray());");
              _builder_4.newLine();
              _builder_4.append("}");
              _builder_4.newLine();
              {
                EList<Variable> _parameters = pattern.getParameters();
                boolean _isEmpty = _parameters.isEmpty();
                boolean _not = (!_isEmpty);
                if (_not) {
                  String _matchClassName_1 = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
                  _builder_4.append(_matchClassName_1, "");
                  _builder_4.append(" other = (");
                  String _matchClassName_2 = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
                  _builder_4.append(_matchClassName_2, "");
                  _builder_4.append(") obj;");
                  _builder_4.newLineIfNotEmpty();
                  {
                    EList<Variable> _parameters_1 = pattern.getParameters();
                    for(final Variable variable : _parameters_1) {
                      _builder_4.append("if (");
                      String _fieldName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                      _builder_4.append(_fieldName, "");
                      _builder_4.append(" == null) {if (other.");
                      String _fieldName_1 = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                      _builder_4.append(_fieldName_1, "");
                      _builder_4.append(" != null) return false;}");
                      _builder_4.newLineIfNotEmpty();
                      _builder_4.append("else if (!");
                      String _fieldName_2 = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                      _builder_4.append(_fieldName_2, "");
                      _builder_4.append(".equals(other.");
                      String _fieldName_3 = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.fieldName(variable);
                      _builder_4.append(_fieldName_3, "");
                      _builder_4.append(")) return false;");
                      _builder_4.newLineIfNotEmpty();
                    }
                  }
                }
              }
              _builder_4.append("return true;");
              it.append(_builder_4);
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      JvmOperation _method_5 = this._eMFJvmTypesBuilder.toMethod(pattern, "equals", _newTypeRef_5, _function_5);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_5, _method_5);
      EList<JvmMember> _members_6 = matchClass.getMembers();
      JvmTypeReference _newTypeRef_6 = this._eMFJvmTypesBuilder.newTypeRef(pattern, Pattern.class);
      final Procedure1<JvmOperation> _function_6 = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotation = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Override.class);
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("try {");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("return ");
              String _matcherClassName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
              _builder.append(_matcherClassName, "	");
              _builder.append(".querySpecification().getPattern();");
              _builder.newLineIfNotEmpty();
              _builder.append("} catch (");
              it.append(_builder);
              PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(it, pattern, IncQueryException.class);
              it.append(" ");
              StringConcatenation _builder_1 = new StringConcatenation();
              _builder_1.append("ex) {");
              _builder_1.newLine();
              _builder_1.append(" \t");
              _builder_1.append("// This cannot happen, as the match object can only be instantiated if the query specification exists");
              _builder_1.newLine();
              _builder_1.append(" \t");
              _builder_1.append("throw new ");
              it.append(_builder_1);
              PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(it, pattern, IllegalStateException.class);
              StringConcatenation _builder_2 = new StringConcatenation();
              _builder_2.append("\t");
              _builder_2.append("(ex);");
              _builder_2.newLine();
              _builder_2.append("}");
              _builder_2.newLine();
              it.append(_builder_2);
            }
          };
          PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      JvmOperation _method_6 = this._eMFJvmTypesBuilder.toMethod(pattern, "pattern", _newTypeRef_6, _function_6);
      boolean _add = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_6, _method_6);
      _xblockexpression = (_add);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers an equals method based on the 'pattern' parameter.
   */
  public Object equalsMethodBody(final Pattern pattern, final ITreeAppendable appendable) {
    return null;
  }
  
  public Object inferCheckBodies(final JvmDeclaredType matchClass, final Pattern pattern) {
    return null;
  }
  
  /**
   * Infers inner classes for Match class based on the input 'pattern'.
   */
  public boolean inferMatchInnerClasses(final JvmDeclaredType matchClass, final Pattern pattern) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = matchClass.getMembers();
      String _matchMutableInnerClassName = this._eMFPatternLanguageJvmModelInferrerUtil.matchMutableInnerClassName(pattern);
      JvmGenericType _makeMatchInnerClass = this.makeMatchInnerClass(matchClass, pattern, _matchMutableInnerClassName, true);
      this._eMFJvmTypesBuilder.<JvmGenericType>operator_add(_members, _makeMatchInnerClass);
      EList<JvmMember> _members_1 = matchClass.getMembers();
      String _matchImmutableInnerClassName = this._eMFPatternLanguageJvmModelInferrerUtil.matchImmutableInnerClassName(pattern);
      JvmGenericType _makeMatchInnerClass_1 = this.makeMatchInnerClass(matchClass, pattern, _matchImmutableInnerClassName, false);
      boolean _add = this._eMFJvmTypesBuilder.<JvmGenericType>operator_add(_members_1, _makeMatchInnerClass_1);
      _xblockexpression = (_add);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers a single inner class for Match class
   */
  public JvmGenericType makeMatchInnerClass(final JvmDeclaredType matchClass, final Pattern pattern, final String innerClassName, final boolean isMutable) {
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
      public void apply(final JvmGenericType it) {
        it.setVisibility(JvmVisibility.DEFAULT);
        it.setStatic(true);
        it.setFinal(true);
        EList<JvmTypeReference> _superTypes = it.getSuperTypes();
        JvmParameterizedTypeReference _createTypeRef = PatternMatchClassInferrer.this.typeReference.createTypeRef(matchClass);
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmParameterizedTypeReference>operator_add(_superTypes, _createTypeRef);
        EList<JvmMember> _members = it.getMembers();
        final Procedure1<JvmConstructor> _function = new Procedure1<JvmConstructor>() {
          public void apply(final JvmConstructor it) {
            it.setSimpleName(innerClassName);
            it.setVisibility(JvmVisibility.DEFAULT);
            EList<Variable> _parameters = pattern.getParameters();
            for (final Variable variable : _parameters) {
              {
                final JvmTypeReference javaType = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.calculateType(variable);
                EList<JvmFormalParameter> _parameters_1 = it.getParameters();
                String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable);
                JvmFormalParameter _parameter = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toParameter(variable, _parameterName, javaType);
                PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter);
              }
            }
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("super(");
                {
                  EList<Variable> _parameters = pattern.getParameters();
                  boolean _hasElements = false;
                  for(final Variable variable : _parameters) {
                    if (!_hasElements) {
                      _hasElements = true;
                    } else {
                      _builder.appendImmediate(", ", "");
                    }
                    String _parameterName = PatternMatchClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.parameterName(variable);
                    _builder.append(_parameterName, "");
                  }
                }
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                it.append(_builder);
              }
            };
            PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
        JvmConstructor _constructor = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toConstructor(pattern, _function);
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmConstructor>operator_add(_members, _constructor);
        EList<JvmMember> _members_1 = it.getMembers();
        JvmTypeReference _newTypeRef = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, boolean.class);
        final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            it.setVisibility(JvmVisibility.PUBLIC);
            EList<JvmAnnotationReference> _annotations = it.getAnnotations();
            JvmAnnotationReference _annotation = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Override.class);
            PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return ");
                _builder.append(isMutable, "");
                _builder.append(";");
                it.append(_builder);
              }
            };
            PatternMatchClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
        JvmOperation _method = PatternMatchClassInferrer.this._eMFJvmTypesBuilder.toMethod(pattern, "isMutable", _newTypeRef, _function_1);
        PatternMatchClassInferrer.this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method);
      }
    };
    JvmGenericType _class = this._eMFJvmTypesBuilder.toClass(pattern, innerClassName, _function);
    return _class;
  }
}
