/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.validation.runtime;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.evm.api.ActivationLifeCycle;
import org.eclipse.incquery.runtime.evm.api.Job;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.evm.api.Scheduler;
import org.eclipse.incquery.runtime.evm.specific.ExecutionSchemas;
import org.eclipse.incquery.runtime.evm.specific.Jobs;
import org.eclipse.incquery.runtime.evm.specific.Rules;
import org.eclipse.incquery.runtime.evm.specific.Schedulers;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum;
import org.eclipse.incquery.runtime.evm.specific.lifecycle.DefaultActivationLifeCycle;
import org.eclipse.incquery.runtime.evm.specific.scheduler.UpdateCompleteBasedScheduler;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.validation.runtime.Constraint;
import org.eclipse.incquery.validation.runtime.MarkerEraserJob;
import org.eclipse.incquery.validation.runtime.MarkerPlacerJob;
import org.eclipse.incquery.validation.runtime.MarkerUpdaterJob;
import org.eclipse.incquery.validation.runtime.ValidationUtil;
import org.eclipse.ui.IEditorPart;

public class ConstraintAdapter {
    private Map<IPatternMatch, IMarker> markerMap = new HashMap<IPatternMatch, IMarker>();
    private RuleEngine engine;

    public ConstraintAdapter(IEditorPart editorPart, Notifier notifier, Logger logger) {
        HashSet rules = Sets.newHashSet();
        for (Constraint<IPatternMatch> constraint : ValidationUtil.getConstraintsForEditorId(editorPart.getSite().getId())) {
            rules.add(Rules.newSimpleMatcherRuleSpecification(constraint.getQuerySpecification(), (ActivationLifeCycle)DefaultActivationLifeCycle.DEFAULT, (Set)ImmutableSet.of((Object)Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((IncQueryActivationStateEnum)IncQueryActivationStateEnum.APPEARED, (IMatchProcessor)new MarkerPlacerJob(this, constraint, logger))), (Object)Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((IncQueryActivationStateEnum)IncQueryActivationStateEnum.DISAPPEARED, (IMatchProcessor)new MarkerEraserJob(this, logger))), (Object)Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((IncQueryActivationStateEnum)IncQueryActivationStateEnum.UPDATED, (IMatchProcessor)new MarkerUpdaterJob(this, constraint, logger))))));
        }
        try {
            IncQueryEngine incQueryEngine = IncQueryEngine.on((Notifier)notifier);
            UpdateCompleteBasedScheduler.UpdateCompleteBasedSchedulerFactory schedulerFactory = Schedulers.getIQEngineSchedulerFactory((IncQueryEngine)incQueryEngine);
            this.engine = ExecutionSchemas.createIncQueryExecutionSchema((IncQueryEngine)incQueryEngine, (Scheduler.ISchedulerFactory)schedulerFactory, (Set)rules);
        }
        catch (IncQueryException e) {
            IncQueryLoggingUtil.getDefaultLogger().error((Object)String.format("Exception occured when creating engine for validation: %s", e.getMessage()), (Throwable)e);
        }
    }

    public void dispose() {
        for (IMarker marker : this.markerMap.values()) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                this.engine.getLogger().error((Object)String.format("Exception occured when removing a marker on dispose: %s", e.getMessage()), (Throwable)e);
            }
        }
        this.engine.dispose();
    }

    public IMarker getMarker(IPatternMatch match) {
        return this.markerMap.get(match);
    }

    public IMarker addMarker(IPatternMatch match, IMarker marker) {
        return this.markerMap.put(match, marker);
    }

    public IMarker removeMarker(IPatternMatch match) {
        return this.markerMap.remove(match);
    }
}

