/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.retevis.theme;

import com.google.common.base.Preconditions;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.services.IDisposable;

public class ColorTheme
implements IDisposable {
    private Color[] nodeColors = new Color[this.size];
    private Color[] textColors = new Color[this.size];
    private int size = 3;

    public ColorTheme(Display display) {
        this.nodeColors[0] = new Color((Device)display, 255, 255, 255);
        this.textColors[0] = new Color((Device)display, 0, 0, 0);
        this.nodeColors[1] = new Color((Device)display, 55, 112, 231);
        this.textColors[1] = new Color((Device)display, 255, 255, 255);
        this.nodeColors[2] = new Color((Device)display, 127, 0, 77);
        this.textColors[2] = new Color((Device)display, 255, 255, 255);
    }

    public Color getNodeColor(int id) {
        Preconditions.checkElementIndex((int)id, (int)this.size);
        return this.nodeColors[id];
    }

    public Color getTextColor(int id) {
        Preconditions.checkElementIndex((int)id, (int)this.size);
        return this.textColors[id];
    }

    public void dispose() {
        int i = 0;
        while (i < this.size) {
            if (this.nodeColors[i] != null) {
                this.nodeColors[i].dispose();
            }
            if (this.textColors[i] != null) {
                this.textColors[i].dispose();
            }
            ++i;
        }
    }
}

