/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.retevis.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.gef4.zest.core.viewers.IEntityStyleProvider;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.runtime.rete.boundary.ReteBoundary;
import org.eclipse.incquery.runtime.rete.construction.Stub;
import org.eclipse.incquery.runtime.rete.construction.psystem.PConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.PVariable;
import org.eclipse.incquery.runtime.rete.index.Indexer;
import org.eclipse.incquery.runtime.rete.index.IndexerWithMemory;
import org.eclipse.incquery.runtime.rete.index.MemoryIdentityIndexer;
import org.eclipse.incquery.runtime.rete.index.MemoryNullIndexer;
import org.eclipse.incquery.runtime.rete.matcher.RetePatternMatcher;
import org.eclipse.incquery.runtime.rete.misc.ConstantNode;
import org.eclipse.incquery.runtime.rete.network.Node;
import org.eclipse.incquery.runtime.rete.network.Production;
import org.eclipse.incquery.runtime.rete.remote.Address;
import org.eclipse.incquery.runtime.rete.single.UniquenessEnforcerNode;
import org.eclipse.incquery.runtime.rete.tuple.MaskedTupleMemory;
import org.eclipse.incquery.runtime.rete.tuple.Tuple;
import org.eclipse.incquery.tooling.ui.retevis.theme.ColorTheme;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;

public class ZestReteLabelProvider
extends LabelProvider
implements IEntityStyleProvider {
    private static final int INDEXER_ID = 0;
    private static final int RETEMATCHER_ID = 1;
    private static final int INPUT_ID = 2;
    private ReteBoundary rb;
    private ColorTheme theme;
    private Map<Node, Collection<Stub<Address<?>>>> reverseMap;

    public void setColors(ColorTheme theme) {
        this.theme = theme;
    }

    public ReteBoundary getRb() {
        return this.rb;
    }

    public void setRb(ReteBoundary rb) {
        this.rb = rb;
        this.resetReverseMap();
        for (Object _o : rb.getAllProductionNodes()) {
            Node productionNode = rb.getHeadContainer().resolveLocal((Address)_o);
            if (!(productionNode instanceof Production)) continue;
            this.initalizeReverseMap((Production)productionNode);
        }
    }

    public String getText(Object element) {
        if (element instanceof Node) {
            String simpleName;
            Node n = (Node)element;
            Class<?> namedClass = n.getClass();
            do {
                simpleName = namedClass.getSimpleName();
                namedClass = namedClass.getSuperclass();
            } while (simpleName == null || simpleName.isEmpty());
            StringBuilder sb = new StringBuilder(simpleName);
            if (n instanceof UniquenessEnforcerNode) {
                UniquenessEnforcerNode un = (UniquenessEnforcerNode)n;
                if (un.getParents().isEmpty() && un.getTag() instanceof ENamedElement) {
                    sb.append(" : " + ((ENamedElement)un.getTag()).getName() + " : ");
                }
                sb.append(" [" + un.getMemory().size() + "]");
            }
            if (n instanceof IndexerWithMemory) {
                MaskedTupleMemory mem = ((IndexerWithMemory)n).getMemory();
                sb.append(" [" + mem.getKeysetSize() + " => " + mem.getTotalSize() + "]");
            }
            if (n instanceof MemoryIdentityIndexer) {
                sb.append(" [" + ((MemoryIdentityIndexer)n).getSignatures().size() + "]");
            }
            if (n instanceof MemoryNullIndexer) {
                sb.append(" [" + ((MemoryNullIndexer)n).getSignatures().size() + "]");
            }
            if (!(n instanceof UniquenessEnforcerNode) && !(n instanceof ConstantNode)) {
                sb.append("\n");
                for (Stub<Address<?>> st : this.getStubsForNode(n)) {
                    sb.append("<");
                    Tuple variablesTuple = st.getVariablesTuple();
                    Object[] objectArray = variablesTuple.getElements();
                    int n2 = objectArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        Object nameObj;
                        Object obj = objectArray[n3];
                        if (obj instanceof PVariable && (nameObj = ((PVariable)obj).getName()) instanceof Variable) {
                            sb.append(((Variable)nameObj).getName());
                        }
                        sb.append("; ");
                        ++n3;
                    }
                    sb.append(">  ");
                }
            }
            if (n instanceof RetePatternMatcher) {
                sb.append(" '" + ((Pattern)((RetePatternMatcher)n).getTag()).getName() + "'");
            }
            return sb.toString();
        }
        return "!";
    }

    public IFigure getTooltip(Object entity) {
        if (entity instanceof Node) {
            Node n = (Node)entity;
            StringBuilder infoBuilder = new StringBuilder("Stubs:\n");
            for (Stub<Address<?>> st : this.getStubsForNode(n)) {
                infoBuilder.append(ZestReteLabelProvider.getEnforcedConstraints(st));
            }
            FlowPage fp = new FlowPage();
            TextFlow nameTf = new TextFlow();
            TextFlow infoTf = new TextFlow();
            nameTf.setText(n.toString());
            infoTf.setText(infoBuilder.toString());
            if (entity instanceof RetePatternMatcher) {
                if (((Node)entity).getTag() instanceof Pattern) {
                    Pattern pattern = (Pattern)((Node)entity).getTag();
                    nameTf.setText(pattern.getName());
                    fp.add((IFigure)nameTf);
                }
            } else if (entity instanceof ConstantNode) {
                ConstantNode node = (ConstantNode)entity;
                ArrayList arrayList = new ArrayList();
                node.pullInto(arrayList);
                StringBuilder sb = new StringBuilder();
                for (Tuple tuple : arrayList) {
                    sb.append(String.valueOf(tuple.toString()) + "\n");
                }
                nameTf.setText(sb.toString());
                fp.add((IFigure)nameTf);
            }
            fp.add((IFigure)infoTf);
            return fp;
        }
        return null;
    }

    private static String getEnforcedConstraints(Stub st) {
        StringBuilder sb = new StringBuilder();
        for (Object _pc : st.getAllEnforcedConstraints()) {
            PConstraint pc = (PConstraint)_pc;
            sb.append("\t[" + pc.getClass().getSimpleName() + "]:");
            for (PVariable v : pc.getAffectedVariables()) {
                sb.append("{" + v.getName() + "}");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private Collection<Stub<Address<?>>> getStubsForNode(Node n) {
        Collection<Stub<Address<?>>> r = this.reverseMap.get(n);
        if (r != null) {
            return r;
        }
        return Collections.emptySet();
    }

    private void resetReverseMap() {
        this.reverseMap = new HashMap();
    }

    private void initalizeReverseMap(Production prod) {
        for (Object _stubOfProd : this.rb.getParentStubsOfReceiver(new Address((Node)prod))) {
            Stub stubOfProd = (Stub)_stubOfProd;
            for (Stub<Address<?>> s : ZestReteLabelProvider.getAllParentStubs(stubOfProd)) {
                Address address = (Address)s.getHandle();
                Node n = this.rb.getHeadContainer().resolveLocal(address);
                Collection<Stub<Address<?>>> t = this.reverseMap.get(n);
                if (t == null) {
                    t = new HashSet();
                }
                t.add(s);
                this.reverseMap.put(n, t);
            }
        }
    }

    private static Collection<Stub<Address<?>>> getAllParentStubs(Stub<Address<?>> st) {
        if (st != null) {
            ArrayList v = new ArrayList();
            v.add(st);
            v.addAll(ZestReteLabelProvider.getAllParentStubs(st.getPrimaryParentStub()));
            v.addAll(ZestReteLabelProvider.getAllParentStubs(st.getSecondaryParentStub()));
            return v;
        }
        return Collections.emptyList();
    }

    public Color getNodeHighlightColor(Object entity) {
        return null;
    }

    public Color getBorderColor(Object entity) {
        return null;
    }

    public Color getBorderHighlightColor(Object entity) {
        return null;
    }

    public int getBorderWidth(Object entity) {
        return 0;
    }

    public Color getBackgroundColour(Object entity) {
        UniquenessEnforcerNode inputNode;
        if (entity instanceof Indexer) {
            return this.theme.getNodeColor(0);
        }
        if (entity instanceof RetePatternMatcher) {
            return this.theme.getNodeColor(1);
        }
        if (entity instanceof UniquenessEnforcerNode && (inputNode = (UniquenessEnforcerNode)entity).getParents().isEmpty()) {
            return this.theme.getNodeColor(2);
        }
        return null;
    }

    public Color getForegroundColour(Object entity) {
        UniquenessEnforcerNode inputNode;
        if (entity instanceof Indexer) {
            return this.theme.getTextColor(0);
        }
        if (entity instanceof RetePatternMatcher) {
            return this.theme.getTextColor(1);
        }
        if (entity instanceof UniquenessEnforcerNode && (inputNode = (UniquenessEnforcerNode)entity).getParents().isEmpty()) {
            return this.theme.getTextColor(2);
        }
        return null;
    }

    public boolean fisheyeNode(Object entity) {
        return false;
    }
}

